% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockCdmFromTables.R
\name{mockCdmFromTables}
\alias{mockCdmFromTables}
\title{Creates a mock cdm_reference from a preexisting cdm_reference object (it can
be empty) and a list of tables. It makes sure that all the observations are
within observation and all individuals are present in person table.}
\usage{
mockCdmFromTables(cdm = mockCdmReference(), tables = list(), seed = NULL)
}
\arguments{
\item{cdm}{A cdm_reference object}

\item{tables}{List of named tables. They can be either omop standard tables
or cohort tables.}

\item{seed}{An integer to fix the seed of random numbers. If NULL seed is not
set.}
}
\value{
a cdm object
}
\description{
Creates a mock cdm_reference from a preexisting cdm_reference object (it can
be empty) and a list of tables. It makes sure that all the observations are
within observation and all individuals are present in person table.
}
\examples{
\donttest{
library(omock)
library(dplyr)

cohort <- tibble(
  cohort_definition_id = c(1, 1, 2, 2, 1, 3, 3, 3, 1, 3),
  subject_id = c(1, 4, 2, 3, 5, 5, 4, 3, 3, 1),
  cohort_start_date = as.Date(c(
    "2020-04-01", "2021-06-01", "2022-05-22", "2010-01-01", "2019-08-01",
    "2019-04-07", "2021-01-01", "2008-02-02", "2009-09-09", "2021-01-01"
  )),
  cohort_end_date = cohort_start_date
)

cdm <- mockCdmFromTables(tables = list(cohort = cohort))

cdm
cdm$cohort
cdm$person

}
}
