% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omicwas.R
\name{ctRUV}
\alias{ctRUV}
\title{Remove Unwanted Variations prior to applying ctassoc}
\usage{
ctRUV(X, W, Y, C = NULL, method = "PCA", nPC = NULL)
}
\arguments{
\item{X}{Matrix (or vector) of traits; samples x traits.}

\item{W}{Matrix of proportion of cell types; samples x cell types.}

\item{Y}{Matrix (or vector) of bulk omics measurements; markers x samples.}

\item{C}{Matrix (or vector) of covariates; samples x covariates.
X, W, Y, C should be numeric.}

\item{method}{\code{"PCA"} or \code{"SVA"}}

\item{nPC}{Number of PCs to be regarded as unwanted variation.
If \code{NULL}, automatically computed by the Auer-Gervini approach.}
}
\value{
Y adjusted for the unwanted variations.
}
\description{
Remove Unwanted Variations prior to applying ctassoc
}
\details{
First, for each marker, the full linear model of the \code{ctassoc}
function is fitted, and the residual is computed.
For the residuals over all markers, the principal components (PCs)
are computed.
The top PCs are regarded as the unwanted variations,
and subtracted from \code{Y}.
}
\seealso{
ctassoc
}
