% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-dffits-plot.R
\name{ols_plot_dffits}
\alias{ols_plot_dffits}
\title{DFFITS plot}
\usage{
ols_plot_dffits(model, size_adj_threshold = TRUE, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{size_adj_threshold}{logical; if \code{TRUE} (the default), size
adjusted threshold is used to determine influential observations.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a
plot object.}
}
\value{
\code{ols_plot_dffits} returns  a list containing the
following components:

\item{outliers}{a \code{data.frame} with observation number and \code{DFFITs} that exceed \code{threshold}}
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Plot for detecting influential observations using DFFITs.
}
\details{
DFFIT - difference in fits, is used to identify influential data points. It
quantifies the number of standard deviations that the fitted value changes
when the ith data point is omitted.

Steps to compute DFFITs:

\itemize{
\item Delete observations one at a time.
\item Refit the regression model on remaining \eqn{n - 1} observations
\item examine how much all of the fitted values change when the ith observation is deleted.
}

An observation is deemed influential if the absolute value of its DFFITS value is greater than:
\deqn{2\sqrt((p + 1) / (n - p -1))}

A size-adjusted cutoff recommended by Belsley, Kuh, and Welsch is
\deqn{2\sqrt(p / n)} and is used by default in \strong{olsrr}.

where \code{n} is the number of observations and \code{p} is the number of predictors including intercept.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_plot_dffits(model)
ols_plot_dffits(model, size_adj_threshold = FALSE)

}
\references{
Belsley, David A.; Kuh, Edwin; Welsh, Roy E. (1980). Regression
Diagnostics: Identifying Influential Data and Sources of Collinearity.

Wiley Series in Probability and Mathematical Statistics.
New York: John Wiley & Sons. ISBN 0-471-05856-4.
}
\seealso{
\code{\link[=ols_plot_dfbetas]{ols_plot_dfbetas()}}
}
