% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-forward-regression.R
\name{ols_step_forward_p}
\alias{ols_step_forward_p}
\alias{ols_step_forward_p.default}
\alias{plot.ols_step_forward_p}
\alias{ols_step_forward}
\title{Stepwise forward regression}
\usage{
ols_step_forward_p(model, ...)

\method{ols_step_forward_p}{default}(model, penter = 0.3, details = FALSE,
  ...)

\method{plot}{ols_step_forward_p}(x, model = NA, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{penter}{p value; variables with p value less than \code{penter} will
enter into the model}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_forward_p}.}
}
\value{
\code{ols_step_forward_p} returns an object of class \code{"ols_step_forward_p"}.
An object of class \code{"ols_step_forward_p"} is a list containing the
following components:

\item{steps}{number of steps}
\item{predictors}{variables added to the model}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by
entering predictors based on p values, in a stepwise manner until there is
no variable left to enter any more.
}
\section{Deprecated Function}{

\code{ols_step_forward()} has been deprecated. Instead use \code{ols_step_forward_p()}.
}

\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_step_forward_p(model)

# stepwise forward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_forward_p(model)
plot(k)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.

Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition).
Chicago, IL., McGraw Hill/Irwin.
}
\seealso{
Other variable selection procedures: \code{\link{ols_step_all_possible}},
  \code{\link{ols_step_backward_aic}},
  \code{\link{ols_step_backward_p}},
  \code{\link{ols_step_best_subset}},
  \code{\link{ols_step_both_aic}},
  \code{\link{ols_step_forward_aic}}
}
