% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_exp_plots.R
\name{make_exp_plots}
\alias{make_exp_plots}
\title{Make experimental plots/strips inside the field boundary}
\usage{
make_exp_plots(
  input_plot_info,
  boundary_data,
  abline_data = NA,
  abline_type = "free"
)
}
\arguments{
\item{input_plot_info}{(data.fram or a list of two data.frames) list of plot information created by make_input_plot()}

\item{boundary_data}{(character) path of the field boundary file or boundary as an sf}

\item{abline_data}{(character or sf) path of the ab-line file or ab-line as an sf}

\item{abline_type}{(character) the type of ab-line generation. Select from "free", "lock", and "none"}
}
\value{
a tibble that include experimental plots as sf
}
\description{
Make experimental plots/strips inside the field boundary, harvester ab-line, and applicator/planter ab-line.
}
\examples{
n_plot_info <-
  prep_plot(
    input_name = "NH3",
    unit_system = "imperial",
    machine_width = 30,
    section_num = 1,
    harvester_width = 20,
    headland_length = 30,
    side_length = 60
  )

exp_data <-
  make_exp_plots(
    input_plot_info = n_plot_info,
    boundary_data = system.file("extdata", "boundary-simple1.shp", package = "ofpetrial"),
    abline_data = system.file("extdata", "ab-line-simple1.shp", package = "ofpetrial"),
    abline_type = "free"
  )

exp_data$exp_plots
}
