% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location_right}
\alias{ph_location_right}
\title{Location of a right body element}
\usage{
ph_location_right(newlabel = NULL, ...)
}
\arguments{
\item{newlabel}{a label to associate with the placeholder.}

\item{...}{unused arguments}
}
\description{
The function will return the location corresponding
to a right bounding box. The function assume the layout 'Two Content'
is existing. This is an helper function, if you don't have a layout
named 'Two Content', use \code{\link[=ph_location_type]{ph_location_type()}} and set arguments
to your specific needs.
}
\examples{
doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(doc, "Hello left", location = ph_location_left())
doc <- ph_with(doc, "Hello right", location = ph_location_right())
print(doc, target = tempfile(fileext = ".pptx"))
}
\seealso{
Other functions for placeholder location: 
\code{\link{ph_location}()},
\code{\link{ph_location_fullsize}()},
\code{\link{ph_location_id}()},
\code{\link{ph_location_label}()},
\code{\link{ph_location_left}()},
\code{\link{ph_location_template}()},
\code{\link{ph_location_type}()}
}
\concept{functions for placeholder location}
