% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_toc}
\alias{body_add_toc}
\title{add table of content}
\usage{
body_add_toc(x, level = 3, pos = "after", style = NULL,
  separator = ";")
}
\arguments{
\item{x}{an rdocx object}

\item{level}{max title level of the table}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}

\item{style}{optional. style in the document that will be used to build entries of the TOC.}

\item{separator}{optional. Some configurations need "," (i.e. from Canada) separator instead of ";"}
}
\description{
add a table of content into an rdocx object.
The TOC will be generated by Word, if the document is not
edited with Word (i.e. Libre Office) the TOC will not be generated.
}
\examples{
library(magrittr)
doc <- read_docx() \%>\% body_add_toc()

print(doc, target = tempfile(fileext = ".docx") )
}
