% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_manipulate.R
\name{ph_slidelink}
\alias{ph_slidelink}
\title{slide link to a placeholder}
\usage{
ph_slidelink(x, type = NULL, id_chr = NULL, slide_index)
}
\arguments{
\item{x}{a pptx device}

\item{type}{placeholder type}

\item{id_chr}{placeholder id (a string). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.
Values can be read from \code{\link{slide_summary}}.}

\item{slide_index}{slide index to reach}
}
\description{
add slide link to a placeholder in the current slide.
}
\examples{
fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with_text(x = doc, type = "title", str = "Un titre 1")
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with_text(x = doc, type = "title", str = "Un titre 2")
doc <- on_slide(doc, 1)
slide_summary(doc) # read column id here
doc <- ph_slidelink(x = doc, id_chr = "2", slide_index = 2)

print(doc, target = fileout )
}
