% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata}
\alias{getdata}
\title{Downloads and processes the data from the API}
\usage{
getdata(origin, destination, year, classification, wrapper)
}
\arguments{
\item{origin}{ISO code for country of origin (e.g. \code{chl} for Chile). 
Run \code{country_codes} in case of doubt.}

\item{destination}{ISO code for country of destination (e.g. \code{chn} for China). 
Run \code{country_codes} in case of doubt.}

\item{year}{Numeric value greater or equal to 1962 and lower of equal to 2016.}

\item{classification}{Any of the available trade classifications in the OEC (\code{sitc}, \code{hs92}, 
\code{hs96}, \code{hs02} or \code{hs07}). Default set to \code{sitc}.}

\item{wrapper}{Argument used by \code{getdata_batch}. Default set to \code{FALSE}.}
}
\description{
Returns a tibble containing imports, exports and relevant metrics 
    (e.g. exports growth w/r to last year) for a  year as the result of different API calls 
    and data transforming. 
    The API returns data for different trade classifications: 
    (i) SITC (1962-2016); (ii) HS92 (1992-2016); (iii) HS96 (1996-2016); (iv) HS02 (2002-2016); 
    (v) HS07 (2007-2016).
}
\examples{
\dontrun{
# The next examples can take more than 5 seconds to compute, and specially for large economies so 
# these are just shown without evaluation according to CRAN rules

# Run `country_codes` to display the full table of countries

# What does Chile export to China?  
# year 2015 - SITC (4 characters)
getdata("chl", "chn", 2015)
# or with explicit parameter
getdata("chl", "chn", 2015, "sitc")

# What does Chile export to China?  
# year 2015 - HS07 (4 and 6 characters)
getdata("chl", "chn", 2015, "hs07")
}
}
\seealso{
\code{getdata_batch}
}
\keyword{functions}
