% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_comparison.R
\name{network_comparison}
\alias{network_comparison}
\title{Creates a network to compare two years}
\usage{
network_comparison(origin, destination, classification, year1, year2)
}
\arguments{
\item{origin}{is the country code of origin (e.g. "chl" for Chile)}

\item{destination}{is the country code of origin (e.g. "chn" for China)}

\item{classification}{refers to the trade classification that can be "6" (HS92 6 characters) or "8" (HS92 8 characters) for the year 1995 and going or "4" (SITC rev.2 4 characters) for the year 1962 and ongoing}

\item{year1}{is the initial year and the OEC's API ranges from 1962 to 2014}

\item{year2}{is the final year and the OEC's API ranges from 1962 to 2014}
}
\value{
Creates an \code{HTML} file with a network visualization that compares two given years.
}
\description{
Creates a network to compare two years
}
\examples{
network_comparison("chl", "chn", 6, 2010, 2014)
}
\keyword{functions}

