% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.4.R
\name{power.4}
\alias{power.4}
\title{Required budget (and/or sample size), power, MDES calculation for four-level CRTs}
\usage{
power.4(cost.model = TRUE, expr = NULL, constraint = NULL,
  sig.level = 0.05, two.tailed = TRUE, es = NULL, power = NULL,
  m = NULL, n = NULL, J = NULL, K = NULL, L = NULL, p = NULL,
  icc2 = NULL, icc3 = NULL, icc4 = NULL, r12 = NULL, r22 = NULL,
  r32 = NULL, r42 = NULL, q = NULL, c1 = NULL, c2 = NULL, c3 = NULL,
  c4 = NULL, c1t = NULL, c2t = NULL, c3t = NULL, c4t = NULL,
  eslim = NULL, powerlim = NULL, Llim = NULL, mlim = NULL,
  rounded = TRUE)
}
\arguments{
\item{cost.model}{logical, perform power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, perform conventional power analyses
(e.g., required sample size, power, or MDES calculation) if FALSE; default is TRUE.}

\item{expr}{returned objects from function \code{\link{od.4}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc2}, \code{icc3}, \code{icc4},
\code{r12}, \code{r22}, \code{r32}, \code{r42},
\code{c1}, \code{c2}, \code{c3}, \code{c4},
\code{c1t}, \code{c2t}, \code{c3t}, \code{c4t}, \code{p}, \code{n}, \code{J}, and \code{K}
used or solved in function \code{\link{od.4}} will
be passed to current function;
only the values of \code{p}, \code{n}, \code{J}, and/or \code{K} that specified or solved in
function \code{\link{od.4}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{specify the constrained values of \code{p}, \code{n}, \code{J},
and/or \code{K} in list format to overwrite
those from \code{expr}; default is NULL.}

\item{sig.level}{significance level or type I error rate, default is 0.05.}

\item{two.tailed}{logical; perform two-tailed tests if TRUE,
perform one-tailed tests if FALSE; default is TRUE.}

\item{es}{effect size.}

\item{power}{statistical power.}

\item{m}{total budget.}

\item{n}{the average level-1 sample size per level-2 unit.}

\item{J}{the average level-2 sample size per level-3 unit.}

\item{K}{the average level-3 sample size per level-4 unit.}

\item{L}{the level-4 sample size across treatment conditions.}

\item{p}{the proportion of level-4 clusters/units assigned to treatment.}

\item{icc2}{the unconditional intraclass correlation coefficient (icc) at level 2.}

\item{icc3}{the unconditional intraclass correlation coefficient (icc) at level 3.}

\item{icc4}{the unconditional intraclass correlation coefficient (icc) at level 4.}

\item{r12}{the proportion of level-1 variance explained by covariates.}

\item{r22}{the proportion of level-2 variance explained by covariates.}

\item{r32}{the proportion of level-3 variance explained by covariates.}

\item{r42}{the proportion of level-4 variance explained by covariates.}

\item{q}{the number of covariates at level 4.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit in control condition.}

\item{c3}{the cost of sampling one level-3 unit in control condition.}

\item{c4}{the cost of sampling one level-4 unit in control condition.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{the cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{the cost of sampling one level-3 unit in treatment condition.}

\item{c4t}{the cost of sampling one level-4 unit in treatment condition.}

\item{eslim}{the range for searching the root of effect size (\code{es}) numerically,
default is c(0, 5).}

\item{powerlim}{the range for searching the root of power (\code{power}) numerically,
default is c(1e-10, 1 - 1e-10).}

\item{Llim}{the range for searching the root of level-4 sample size (\code{L}) numerically,
default is c(4, 10e10).}

\item{mlim}{the range for searching the root of budget (\code{m}) numerically,
default is the costs sampling \code{Llim} level-4 units across treatment conditions
or c(4 * Lcost, 10e10 * Lcost), with Lcost =
((1 - p) * (c1 * n * J * K + c2 * J * K + c3 * K + c4) +
p * (c1t * n * J * K + c2t * J * K + c3t * K + c4t)).}

\item{rounded}{logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions \code{\link{od.4}}
to two decimal places and integer, respectively if TRUE,
no rounding if FALSE; default is TRUE.}
}
\value{
Required budget (and/or required level-4 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for four-level cluster randomized trials (CRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# unconstrained optimal design
myod1 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500)
myod1$out # output # n = 7.1, J = 3.2, K = 4.2, p = 0.23

# ------- power analyses by default considering costs and budget -------
# required budget and sample size
mym.1 <- power.4(expr = myod1, es = 0.3, q = 1, power = 0.8)
mym.1$out  # m = 33188, L = 26.6
mym.1$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
mym.1 <- power.4(es = 0.3, power = 0.8, q = 1,
                 icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
                 r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
                 c1 = 1, c2 = 5, c3 = 25, c4 = 125,
                 c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
                 n = 7, J = 3, K = 4, p = 0.23)
# required budget and sample size with constrained p
mym.2 <- power.4(expr = myod1, es = 0.3, q = 1, power = 0.8,
                 constraint = list(p = 0.5))
mym.2$out  # m = 44584, L = 19.6
# required budget and sample size with constrained p and K
mym.3 <- power.4(expr = myod1, es = 0.3, q = 1, power = 0.8,
                 constraint = list(p = 0.5, K = 20))
mym.3$out  # m = 79108, L = 12.9

# Power calculation
mypower <- power.4(expr = myod1, q = 1, es = 0.3, m = 33188)
mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
mypower.1 <- power.4(expr = myod1, q = 1, es = 0.3, m = 33188,
                 constraint = list(p = 0.5))
mypower.1$out  # power = 0.65

# MDES calculation
mymdes <- power.4(expr = myod1, q = 1, power = 0.80, m = 33188)
mymdes$out  # MDES = 0.30


# ------- conventional power analyses with cost.model = FALSE-------
# Required sample size
myL <- power.4(cost.model = FALSE, expr = myod1, es = 0.3, q = 1, power = 0.8)
myL$out  # L = 26.6
myL$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
myL <- power.4(cost.model = FALSE, es = 0.3, power = 0.8, q = 1,
                  icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
                  r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
                  n = 7, J = 3, K = 4, p = 0.23)

# Power calculation
 mypower1 <- power.4(cost.model = FALSE, expr = myod1, L = 27, es = 0.3, q = 1)
 mypower1$out  # power = 0.806

# MDES calculation
mymdes1 <- power.4(cost.model = FALSE, expr = myod1, L = 27, power = 0.8, q = 1)
mymdes1$out  # es = 0.30


}
\references{
Shen, Z.(in progress). Using optimal sample allocation to
  improve design efficiency for multilevel randomized trials.
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
