% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push_data.R
\name{push_data}
\alias{push_data}
\title{push_data}
\usage{
push_data(target = "", briefcase = "odkBriefcase_latest", id = "",
  to = "", from = "", username, password)
}
\arguments{
\item{target}{Path to directory of ODK Briefcase \code{.jar} file. Directory
path should match directory path used when calling \code{get_briefcase()}.
If ODK Briefcase \code{.jar} file was downloaded manually from \url{https://opendatakit.org},
\code{target} should match the directory path where \code{.jar} file has
been downloaded into.}

\item{briefcase}{Filename of the downloaded ODK Briefcase \code{.jar} file.
Default is \code{odkBriefcase_latest} to match the default filename used
by \code{get_briefcase()}. If ODK Briefcase \code{.jar} file was
downloaded manually from \url{https://opendatakit.org}, filename should
match the default filename used by Open Data Kit which is usually
"ODK Briefcase vX.Y.Z Production.jar" where vX.Y.Z is the version number}

\item{id}{Form ID of form to push ODK forms data into}

\item{to}{URL of remote ODK Aggregate server}

\item{from}{Directory containing ODK forms data to push to remote ODK aggregate
server}

\item{username}{Username for account in remote ODK Aggregate server from
which forms are to be pulled}

\item{password}{Password for account in remote ODK Aggregate server from
which forms are to be pulled}
}
\description{
Push ODK forms from local ODK Briefcase Storage folder to remote ODK Aggregate
via ODK Briefcase
}
\examples{
  # Use latest ODK Briefcase and connect to a test
  # remote ODK Aggregate server from ONA (https://ona.io) to push ODK forms
  # data into
  \dontrun{
  dirPath <- tempdir()
  get_briefcase(destination = dirPath)
  push_data(target = dirPath,
            id = "stakeholders",
            to = "https://ona.io/validtrial",
            from = dirPath,
            username = "validtrial",
            password = "zEF-STN-5ze-qom")
  }

}
