% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or_glm.R
\name{or_glm}
\alias{or_glm}
\title{Calculate Odds Ratios of Generalized Linear (Mixed) Models}
\usage{
or_glm(data, model, incr, ci = 0.95)
}
\arguments{
\item{data}{The data used for model fitting.}

\item{model}{A fitted GLM(M).}

\item{incr}{Increment values of each predictor given in a named list.}

\item{ci}{Which confidence interval to calculate. Must be between 0
and 1. Default to 0.95}
}
\value{
A data frame with five columns:
\item{predictor}{Predictor name(s)}
\item{oddsratio}{Calculated odds ratio(s)}
\item{ci_low}{Lower confident interval of odds ratio}
\item{ci_high}{Higher confident interval of odds ratio}
\item{increment}{Increment of the predictor(s)}
}
\description{
This function calculates odds ratio(s) for specific increment
steps of GLMs.
}
\details{
\code{ci_low} and \code{ci_high} are only calculated for GLM models because
\code{\link[MASS:glmmPQL]{MASS::glmmPQL()}} does not return confident intervals due to its penalizing
behavior.

Currently supported functions: \link[stats:glm]{stats::glm},\link[MASS:glmmPQL]{MASS::glmmPQL}
}
\examples{
## Example with glm()
library(oddsratio)
# load data (source: http://www.ats.ucla.edu/stat/r/dae/logit.htm) and
# fit model
fit_glm <- glm(admit ~ gre + gpa + rank,
  data = data_glm,
  family = "binomial"
) # fit model

# Calculate OR for specific increment step of continuous variable
or_glm(data = data_glm, model = fit_glm, incr = list(gre = 380, gpa = 5))

# Calculate OR and change the confidence interval level
or_glm(
  data = data_glm, model = fit_glm,
  incr = list(gre = 380, gpa = 5), ci = .70
)

## Example with MASS:glmmPQL()
# load data
library(MASS)
data(bacteria)
fit_glmmPQL <- glmmPQL(y ~ trt + week,
  random = ~ 1 | ID,
  family = binomial, data = bacteria,
  verbose = FALSE
)

# Apply function
or_glm(data = bacteria, model = fit_glmmPQL, incr = list(week = 5))
}
\seealso{
\code{\link[=or_gam]{or_gam()}}
}
