% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver-databricks.R
\docType{class}
\name{databricks}
\alias{databricks}
\alias{DatabricksOdbcDriver-class}
\alias{dbConnect,DatabricksOdbcDriver-method}
\title{Helper for Connecting to Databricks via ODBC}
\usage{
databricks()

\S4method{dbConnect}{DatabricksOdbcDriver}(
  drv,
  httpPath,
  workspace = Sys.getenv("DATABRICKS_HOST"),
  useNativeQuery = TRUE,
  driver = NULL,
  HTTPPath,
  ...
)
}
\arguments{
\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{httpPath, HTTPPath}{To query a cluster, use the HTTP Path value found
under \verb{Advanced Options > JDBC/ODBC} in the Databricks UI. For SQL
warehouses, this is found under \verb{Connection Details} instead.}

\item{workspace}{The URL of a Databricks workspace, e.g.
\code{"https://example.cloud.databricks.com"}.}

\item{useNativeQuery}{Suppress the driver's conversion from ANSI SQL 92 to
HiveSQL? The default (\code{TRUE}), gives greater performance but means that
paramterised queries (and hence \code{dbWriteTable()}) do not work.}

\item{driver}{The name of the Databricks ODBC driver, or \code{NULL} to use the
default name.}

\item{...}{Further arguments passed on to \code{\link[=dbConnect]{dbConnect()}}.}
}
\value{
An \code{OdbcConnection} object with an active connection to a Databricks
cluster or SQL warehouse.
}
\description{
Connect to Databricks clusters and SQL warehouses via the \href{https://www.databricks.com/spark/odbc-drivers-download}{Databricks ODBC driver}.

In particular, the custom \code{dbConnect()} method for the Databricks ODBC driver
implements a subset of the \href{https://docs.databricks.com/en/dev-tools/auth.html#databricks-client-unified-authentication}{Databricks client unified authentication}
model, with support for personal access tokens, OAuth machine-to-machine
credentials, and OAuth user-to-machine credentials supplied via Posit
Workbench or the Databricks CLI on desktop.
All of these credentials are detected automatically if present using
\href{https://docs.databricks.com/en/dev-tools/auth.html#environment-variables-and-fields-for-client-unified-authentication}{standard environment variables}.
}
\examples{
\dontrun{
DBI::dbConnect(
  odbc::databricks(),
  httpPath = "sql/protocolv1/o/4425955464597947/1026-023828-vn51jugj"
)
}
}
