% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{predict.mml}
\alias{predict.mml}
\title{Prediction Method for mml Objects}
\usage{
\method{predict}{mml}(object, data = NULL, ...)
}
\arguments{
\item{object}{An \code{mml} object.}

\item{data}{Data set of class \code{data.frame}. It must contain the same covariates used to train the base learners. If \code{data} is \code{NULL}, then \code{object$X} is used.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Matrix of predictions.
}
\description{
Prediction method for class \code{mml}.
}
\details{
If \code{object$learner == "l1"}, then \code{\link[stats]{model.matrix}} is used to handle non-numeric covariates. If we also
have \code{object$scaling == TRUE}, then \code{data} is scaled to have zero mean and unit variance.
}
\examples{
\donttest{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:100, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Training-test split.
train_idx <- sample(seq_len(length(y)), floor(length(y) * 0.5))

y_tr <- y[train_idx]
X_tr <- X[train_idx, ]

y_test <- y[-train_idx]
X_test <- X[-train_idx, ]

## Fit multinomial machine learning on training sample using two different learners.
multinomial_forest <- multinomial_ml(y_tr, X_tr, learner = "forest")
multinomial_l1 <- multinomial_ml(y_tr, X_tr, learner = "l1")

## Predict out of sample.
predictions_forest <- predict(multinomial_forest, X_test)
predictions_l1 <- predict(multinomial_l1, X_test)

## Compare predictions.
cbind(head(predictions_forest), head(predictions_l1))}

}
\seealso{
\code{\link{multinomial_ml}}, \code{\link{ordered_ml}}
}
\author{
Riccardo Di Francesco
}
