% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{[[<-,adp-method}
\alias{[[<-,adp-method}
\title{Replace Parts of an ADP Object}
\usage{
\S4method{[[}{adp}(x, i, j, ...) <- value
}
\arguments{
\item{x}{an \linkS4class{adp} object.}

\item{i}{character value naming the item to replace.}

\item{j}{optional additional information on the \code{i} item.}

\item{...}{optional additional information (ignored).}

\item{value}{The value to be placed into \code{x}, somewhere.}
}
\description{
In addition to the usual insertion of elements by name, note
that e.g. \code{pitch} gets stored into \code{pitchSlow}.

The \code{[[<-} method works for all \linkS4class{oce} objects.
The purpose, as with the related extraction method, \code{[[},
is to insulate users from the internal details of \linkS4class{oce}
objects, by looking for items within the various storage
slots of the object. Items not actually stored can also be
replaced, including units and data-quality
flags.
}
\details{
As with \code{[[} method, the procedure works in steps.

First, the \code{metadata} slot of \code{x} is checked to
see whether it contains something named with \code{i}.
If so, then the named item is replaced with \code{value}.

Otherwise, if the string value of \code{i} ends in \code{Unit}, then the
characters preceding that are taken as the name of a variable, and
the \code{metadata} slot of \code{x} is updated to store that unit, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{x[["temperatureUnits"]] <- list(unit=expression(degree*F),scale="")
}\if{html}{\out{</div>}}

Similarly, if \code{i} ends in \code{Flag}, then quality-control
flags are set up as defined by \code{result}, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{o[["temperatureFlags"]] <- c(2,4,2,2)
}\if{html}{\out{</div>}}

Otherwise, \code{\link[=pmatch]{pmatch()}} is used for a partial-string match with
the names of the items that are in the \code{data} slot of \code{x}.
The first item found (if any) is then updated to hold the value \code{result}.

If none of these conditions is met, a warning is issued.
}
\seealso{
Other functions that replace parts of oce objects: 
\code{\link{[[<-,amsr-method}},
\code{\link{[[<-,argo-method}},
\code{\link{[[<-,bremen-method}},
\code{\link{[[<-,cm-method}},
\code{\link{[[<-,coastline-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{[[<-,echosounder-method}},
\code{\link{[[<-,g1sst-method}},
\code{\link{[[<-,gps-method}},
\code{\link{[[<-,ladp-method}},
\code{\link{[[<-,landsat-method}},
\code{\link{[[<-,lisst-method}},
\code{\link{[[<-,lobo-method}},
\code{\link{[[<-,met-method}},
\code{\link{[[<-,oce-method}},
\code{\link{[[<-,odf-method}},
\code{\link{[[<-,rsk-method}},
\code{\link{[[<-,sealevel-method}},
\code{\link{[[<-,section-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{[[<-,topo-method}},
\code{\link{[[<-,windrose-method}},
\code{\link{[[<-,xbt-method}}

Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{functions that replace parts of oce objects}
\concept{things related to adp data}
