% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{read.section}
\alias{read.section}
\title{Read a Section File}
\usage{
read.section(
  file,
  directory,
  sectionId = "",
  flags,
  ship = "",
  scientist = "",
  institute = "",
  missingValue = -999,
  debug = getOption("oceDebug"),
  processingLog
)
}
\arguments{
\item{file}{A file containing a set of CTD observations.  At present, only the
\emph{exchange BOT} format is accepted (see Details).}

\item{directory}{A character string indicating the name of a  directory that
contains a set of CTD files that hold individual stations in the section.}

\item{sectionId}{Optional string indicating the name for the section.  If not
provided, the section ID is determined by examination of the file header.}

\item{flags}{Ignored, and deprecated (will be disallowed in a future version).}

\item{ship}{Name of the ship carrying out the sampling.}

\item{scientist}{Name of chief scientist aboard ship.}

\item{institute}{Name of chief scientist's institute.}

\item{missingValue}{Numerical value used to indicate missing data.}

\item{debug}{Logical. If \code{TRUE}, print some information that might be
helpful during debugging.}

\item{processingLog}{If provided, the action item to be stored in the log.  This
is typically only provided for internal calls; the default that it provides is
better for normal calls by a user.}
}
\value{
A \linkS4class{section} object.
}
\description{
Read a file that contains a series of \code{ctd} profiles that make up an
oceanographic section.
Only \emph{exchange BOT} comma-separated value format is permitted at this time,
but other formats may be added later.  It should also be noted that the parsing
scheme was developed after inspection of the A03 data set (see Examples). This
may cause problems if the format is not universal. For example, the header must
name the salinity column "\code{CTDSAL}"; if not, salinity values will not be
read from the file.
}
\section{Disambiguating salinity}{

WOCE datasets commonly have a column named \code{CTDSAL} for salinity inferred
from a CTD and \code{SALNTY} (not a typo) for salinity derived from bottle data.
If only one of these is present in the data file, the data will be called
\code{salinity} in the \code{data} slot of the return value. However, if both
are present, then \code{CTDSAL} is stored as \code{salinity} and \code{SALNTY}
is stored as \code{salinityBottle}.
}

\references{
Several repository sites provide section data. An example that is perhaps likely
to exist for years is \url{https://cchdo.ucsd.edu}, but a search on \code{"WOCE
  bottle data"} should turn up other sites, if this one ceases to exist. Only
the so-called \emph{exchange BOT} data format can be processed by read.section()
at this time. Data names are inferred from column headings using
\code{\link[=woceNames2oceNames]{woceNames2oceNames()}}.
}
\seealso{
Other things related to section data: 
\code{\link{[[,section-method}},
\code{\link{[[<-,section-method}},
\code{\link{as.section}()},
\code{\link{handleFlags,section-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{plot,section-method}},
\code{\link{section-class}},
\code{\link{sectionAddStation}()},
\code{\link{sectionGrid}()},
\code{\link{sectionSmooth}()},
\code{\link{sectionSort}()},
\code{\link{section}},
\code{\link{subset,section-method}},
\code{\link{summary,section-method}}
}
\author{
Dan Kelley
}
\concept{things related to section data}
