% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{plot,ctd-method}
\alias{plot,ctd-method}
\alias{plot.ctd}
\title{Plot CTD Data}
\usage{
\S4method{plot}{ctd}(
  x,
  which,
  col = par("fg"),
  fill,
  borderCoastline = NA,
  colCoastline = "lightgray",
  eos = getOption("oceEOS", default = "gsw"),
  ref.lat = NaN,
  ref.lon = NaN,
  grid = TRUE,
  coastline = "best",
  Slim,
  Clim,
  Tlim,
  plim,
  densitylim,
  N2lim,
  Rrholim,
  dpdtlim,
  timelim,
  lonlim,
  latlim,
  drawIsobaths = FALSE,
  clongitude,
  clatitude,
  span,
  showHemi = TRUE,
  lonlabels = TRUE,
  latlabels = TRUE,
  projection = NULL,
  parameters = NULL,
  orientation = NULL,
  latlon.pch = 20,
  latlon.cex = 1.5,
  latlon.col = "red",
  cex = 1,
  cex.axis = par("cex.axis"),
  pch = 1,
  useSmoothScatter = FALSE,
  df,
  keepNA = FALSE,
  type,
  mgp = getOption("oceMgp"),
  mar = c(mgp[1] + 1.5, mgp[1] + 1.5, mgp[1] + 1.5, mgp[1] + 1),
  inset = FALSE,
  add = FALSE,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{x}{a \linkS4class{ctd} object.}

\item{which}{List of desired plot types, as given below. If \code{which} is not
supplied, a default will be used. This default will be \code{c(1,2,3,5)} if the
CTD is in profiling mode (i.e. if \code{deploymentType} in the \code{metadata}
slot equals \code{"profile"},
or is missing) or
\code{"moored"}/\code{"thermosalinograph"}, the default will be \code{c(30, 3, 31, 5)}.  If it
is \code{"towyo"}, \code{c(30, 31, 32, 3)} will be used. Details are as
follows.
\itemize{
\item \code{which=1} or \code{which="salinity+temperature"} gives
a combined profile of temperature and salinity
\item \code{which=2} or \code{which="density+N2"} gives a combined
profile of \eqn{\sigma_\theta}{sigma-theta} and \eqn{N^2}{N^2}
\item \code{which=3} or \code{which="TS"} gives a TS plot
\item \code{which=4} or \code{which="text"} gives a textual
summary of some aspects of the data
\item \code{which=5} or \code{which="map"} gives a map plotted
with \code{\link[=plot,coastline-method]{plot,coastline-method()}}, with a dot for
the station location.  Notes near the top boundary of the map give the
station number, the sampling date, and the name of the chief scientist,
if these are known. Note that the longitude will be converted to a value
between -180 and 180 before plotting.  (See also notes
about \code{span}.)
\item \code{which=5.1} as for \code{which=5}, except that the file name
is drawn above the map
\item \code{which=6} or \code{which="density+dpdt"} gives a
profile of density and \eqn{dP/dt}{dP/dt}, which is useful for
evaluating whether the instrument is dropping properly through the
water column
\item \code{which=7} or \code{which="density+time"} gives a
profile of density and time
\item \code{which=8} or \code{which="index"} gives a profile of
index number (especially useful for \code{\link[=ctdTrim]{ctdTrim()}})
\item \code{which=9} or \code{which="salinity"} gives a salinity profile
\item \code{which=10} or \code{which="temperature"} gives a temperature profile
\item \code{which=11} or \code{which="density"} gives a density profile
\item \code{which=12} or \code{which="N2"} gives an \eqn{N^2}{N^2} profile
\item \code{which=13} or \code{which="spice"} gives a spiciness profile
\item \code{which=14} or \code{which="tritium"} gives a tritium profile
\item \code{which=15} or \code{which="Rrho"} gives an Rrho profile
\item \code{which=16} or \code{which="RrhoSF"} gives an RrhoSF profile
\item \code{which=17} or \code{which="conductivity"} gives a conductivity profile
\item \code{which=20} or \code{which="CT"} gives a Conservative Temperature profile
\item \code{which=21} or \code{which="SA"} gives an Absolute Salinity profile
\item \code{which=30} gives a time series of Salinity
\item \code{which=31} gives a time series of Temperature
\item \code{which=32} gives a time series of pressure
\item \code{which=33} gives a time series of sigmaTheta
}}

\item{col}{Color of lines or symbols.}

\item{fill}{A legacy parameter that will be permitted only temporarily; see
\dQuote{History}.}

\item{borderCoastline}{Color of coastlines and international borders, passed
to \code{\link[=plot,coastline-method]{plot,coastline-method()}} if a map is included in \code{which}.}

\item{colCoastline}{Fill color of coastlines and international borders, passed
to \code{\link[=plot,coastline-method]{plot,coastline-method()}} if a map is included in \code{which}. Set to
\code{NULL} to avoid filling.}

\item{eos}{String indicating the equation of state to be used, either
\code{"unesco"} or \code{"gsw"}.}

\item{ref.lat}{Latitude of reference point for distance calculation.}

\item{ref.lon}{Longitude of reference point for distance calculation.}

\item{grid}{Set \code{TRUE} to get a grid on all plots.}

\item{coastline}{A specification of the coastline to be used for
\code{which="map"}.  This may be a coastline object, whether built-in or
supplied by the user, or a character string.  If the later, it may be the
name of a built-in coastline (\code{"coastlineWorld"},
\code{"coastlineWorldFine"}, or
\code{"coastlineWorldCoarse"}), or \code{"best"}, to choose
a suitable coastline for the locale, or \code{"none"} to prevent
the drawing of a coastline.  There is a speed penalty for providing
\code{coastline} as a character string, because it forces
\code{\link[=plot,coastline-method]{plot,coastline-method()}} to load it on every call.  So, if
\code{\link[=plot,coastline-method]{plot,coastline-method()}} is to be called several times for a given
coastline, it makes sense to load it in before the first call, and to
supply the object as an argument, as opposed to the name of the object.}

\item{Slim}{Optional limits of salinity axes.}

\item{Clim}{Optional limits of conductivity axes.}

\item{Tlim}{Optional limits of temperature axes.}

\item{plim}{Optional limits of pressure axes.}

\item{densitylim}{Optional limits of density axis, whether that axis be horizontal
or vertical.}

\item{N2lim}{Optional limits of \eqn{N^2}{N^2} axis.}

\item{Rrholim}{Optional limits of \eqn{R_rho}{R_rho} axis.}

\item{dpdtlim}{Optional limits of dP/dt axis.}

\item{timelim}{Optional limits of delta-time axis.}

\item{lonlim}{Optional limits of longitude axis of map (ignored if no map
plotted) DEPRECATED 2014-01-07.}

\item{latlim}{Optional limits of latitude axis of map (ignored if no map
plotted) DEPRECATED 2014-01-07.}

\item{drawIsobaths}{An indication of whether to draw depth contours on
maps, in addition to the coastline. The argument has no effect except
for panels in which the value of \code{which} equals \code{"map"} or
the equivalent numerical code, \code{5}. If \code{drawIsobaths} is
\code{FALSE}, then no contours are drawn. If \code{drawIsobaths}
is \code{TRUE}, then contours are selected automatically,
using \link{pretty}\code{(c(0,300))} if the station depth is
under 100m or \link{pretty}\code{(c(0,5500))} otherwise.
If \code{drawIsobaths} is a numerical vector,
then the indicated depths are drawn. For plots drawn with \code{projection}
set to \code{NULL}, the contours are added with \code{\link[=contour]{contour()}}
and otherwise \code{\link[=mapContour]{mapContour()}} is used. To customize
the resultant contours, e.g. setting particular line types or colors,
users should call these functions directly (see e.g. Example 2).}

\item{clongitude}{Center longitude.}

\item{clatitude}{Center latitude.}

\item{span}{Optional span of map, in km.  If not given, this will be determined
as a small multiple of the distance to the nearest point of land, in an
attempt to show some coastline in the plot.}

\item{showHemi}{Logical indicating whether to show hemisphere in axis tick
labels.}

\item{lonlabels, latlabels}{Values that control the labelling of
longitude and latitude along the sides of the plot, used only if
\code{projection} is not \code{NULL}.  See \code{\link[=mapPlot]{mapPlot()}} for details.}

\item{projection}{Projection for map, if desired.  If this is \code{NULL}, no
projection will be used; the map will simply show longitude and latitude in a
cartesian frame, scaled to retain shapes at the centre.  If this is the string
\code{"automatic"}, then either a Mercator or Stereographic projection will be
used, depending on whether the CTD station is within 70 degrees of the equator
or at higher latitudes.  Finally, if this is a string in the format used by
\code{\link[=mapPlot]{mapPlot()}}, then it is is passed to that function.}

\item{parameters}{a \strong{deprecated} argument that has been ignored
since February 2016; see \link{oce-deprecated}.}

\item{orientation}{a \strong{deprecated} argument that has been ignored
since February 2016; see \link{oce-deprecated}.}

\item{latlon.pch}{Symbol code for sample location (ignored if no map plotted).}

\item{latlon.cex}{Symbol expansion factor for sample location (ignored if no
map plotted).}

\item{latlon.col}{Color of symbol for sample location (ignored if no map
plotted).}

\item{cex}{Size to be used for plot symbols (see \code{\link[=par]{par()}}).}

\item{cex.axis}{Size factor for axis labels (see \code{\link[=par]{par()}}).}

\item{pch}{Code for plotting symbol (see \code{\link[=par]{par()}}).}

\item{useSmoothScatter}{Boolean, set to \code{TRUE} to use
\code{\link[=smoothScatter]{smoothScatter()}} instead of \code{\link[=plot]{plot()}} to draw the plot.}

\item{df}{Optional argument that is ignored except for plotting buoyancy
frequency; in that case, it is passed to \code{\link[=swN2]{swN2()}} as the argument
named \code{df}.}

\item{keepNA}{Flag indicating whether to keep \code{NA} values in linegraphs,
which will yield breaks in the lines.}

\item{type}{The type of plot to draw, using the same scheme as
\code{\link[=plot]{plot()}}. If supplied, this is increased to be the
same length as \code{which}, if necessary, and then supplied to
each of the individual plot calls. If it is not supplied,
then those plot calls use defaults (e.g. using a line for
\code{\link[=plotProfile]{plotProfile()}}, using dots for \code{\link[=plotTS]{plotTS()}},
etc).}

\item{mgp}{Three-element numerical vector specifying axis-label geometry,
passed to \code{\link[=par]{par()}}.
The default establishes tighter margins than in the usual R setup.}

\item{mar}{Four-element numerical vector specifying margin geometry,
passed to \code{\link[=par]{par()}}.
The default establishes tighter margins than in the usual R setup.
Note that the value of \code{mar} is ignored for the map panel
of multi-panel maps; instead, the present value of
\link{par}\code{("mar")} is used, which in the default call will
make the map plot region equal that of the previously-drawn
profiles and TS plot.}

\item{inset}{Set to \code{TRUE} for use within \code{\link[=plotInset]{plotInset()}}.  The
effect is to prevent the present function from adjusting margins, which is
necessary because margin adjustment is the basis for the method used by
\code{\link[=plotInset]{plotInset()}}.}

\item{add}{Logical, indication of whether to add to an existing plot.  This
only works if \code{length(which)=1}, and it will yield odd results if the
value of \code{which} does not match that in the previous plots.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}

\item{...}{Optional arguments passed to plotting functions. A common example is
to set \code{df}, for use in \code{\link[=swN2]{swN2()}} calculations.}
}
\description{
Plot CTD data, by default in a four-panel display showing (a) profiles of
salinity and temperature, (b) profiles of density and the square of buoyancy
frequency, (c) a TS diagram and (d) a coastline diagram indicating the station
location.
}
\details{
Creates a multi-panel summary plot of data measured in a CTD cast. The
default values of \code{which} and other arguments are chosen to be useful
for quick overviews of data. However, for detailed work it is common
to call the present function with just a single value of \code{which}, e.g.
with four calls to get four panels. The advantage of this is that it provides
much more control over the display, and also it permits the addition of extra
display elements (lines, points, margin notes, etc.) to the individual panels.

Note that panels that draw more than one curve (e.g. \code{which="salinity+temperature"}
draws temperature and salinity profiles in one graph), the value of \link{par}\code{("usr")}
is established by the second profile to have been drawn. Some experimentation will
reveal what this profile is, for each permitted \code{which} case, although
it seems unlikely that this will help much ... the simple fact is that drawing two
profiles in one graph is useful for a quick overview, but not useful for e.g. interactive
analysis with \code{\link[=locator]{locator()}} to flag bad data, etc.
}
\section{History}{

Until February, 2016, \code{\link[=plot,ctd-method]{plot,ctd-method()}} relied on a now-defunct argument
\code{fill} to control colors; \code{colCoastline} is to be used now, instead.
Also, now it is possible to set the color of coasts and international
boundaries, with \code{borderCoastline}.
}

\examples{
## 1. simple plot
library(oce)
data(ctd)
plot(ctd)

## 2. how to customize depth contours
par(mfrow=c(1,2))
data(section)
stn <- section[["station", 105]]
plot(stn, which='map', drawIsobaths=TRUE)
plot(stn, which='map')
data(topoWorld)
tlon <- topoWorld[["longitude"]]
tlat <- topoWorld[["latitude"]]
tdep <- -topoWorld[["z"]]
contour(tlon, tlat, tdep, drawlabels=FALSE,
        levels=seq(1000,6000,1000), col='lightblue', add=TRUE)
contour(tlon, tlat, tdep, vfont=c("sans serif", "bold"),
        levels=stn[['waterDepth']], col='red', lwd=2, add=TRUE)

}
\seealso{
The documentation for \linkS4class{ctd} explains the structure of CTD
objects, and also outlines the other functions dealing with them.

Other functions that plot oce data: 
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdTrim}()},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to ctd data}
