% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{resizableLabel}
\alias{resizableLabel}
\title{Provide axis names in adjustable sizes}
\usage{
resizableLabel(item, axis = "x", sep, unit = NULL,
  debug = getOption("oceDebug"))
}
\arguments{
\item{item}{code for the label.  This must be an element from the following
list, or an abbreviation that uniquely identifies an element through its
first letters: \code{"S"}, \code{"C"}, \code{"conductivity mS/cm"},
\code{"conductivity S/m"}, \code{"T"}, \code{"theta"}, \code{"sigmaTheta"},
\code{"conservative temperature"}, \code{"absolute salinity"},
\code{"nitrate"}, \code{"nitrite"}, \code{"oxygen"}, \code{"oxygen
saturation"}, \code{"oxygen mL/L"}, \code{"oxygen umol/L"}, \code{"oxygen
umol/kg"}, \code{"phosphate"}, \code{"silicate"}, \code{"tritium"},
\code{"spice"}, \code{"fluorescence"}, \code{"p"}, \code{"z"},
\code{"distance"}, \code{"distance km"}, \code{"along-track distance km"},
\code{"heading"}, \code{"pitch"}, \code{"roll"}, \code{"u"}, \code{"v"},
\code{"w"}, \code{"speed"}, \code{"direction"}, \code{"eastward"},
\code{"northward"}, \code{"depth"}, \code{"elevation"}, \code{"latitude"},
\code{"longitude"}, \code{"frequency cph"}, or \code{"spectral density
m2/cph"}.}

\item{axis}{a string indicating which axis to use; must be \code{x} or
\code{y}.}

\item{sep}{optional character string inserted between the unit and the
parentheses or brackets that enclose it. If not provided, then
\code{\link{getOption}("oceUnitSep")} is checked. If that exists, then it is
used as the separator; if not, no separator is used.}

\item{unit}{optional unit to use, if the default is not satisfactory. This
might be the case if for example temperature was not measured in Celcius.}

\item{debug}{optional debugging flag. Setting to 0 turns off debugging,
while setting to 1 causes some debugging information to be printed.}
}
\value{
A character string or expression, in either a long or a shorter
format, for use in the indicated axis at the present plot size.  Whether the
unit is enclosed in parentheses or square brackets is determined by the
value of \code{getOption("oceUnitBracket")}, which may be \code{"["} or
\code{"("}.  Whether spaces are used between the unit and these deliminators
is set by \code{psep} or \code{\link{getOption}("oceUnitSep")}.
}
\description{
Provide axis names in adjustable sizes, e.g. using T instead of Temperature,
and including units as appropriate.
Used by e.g. \code{\link{plot,ctd-method}}.
}
\author{
Dan Kelley
}
