% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{head.oce}
\alias{head.oce}
\title{Extract The Start of an Oce Object}
\usage{
\method{head}{oce}(x, n = 6L, ...)
}
\arguments{
\item{x}{An \code{oce} object.}

\item{n}{Number of elements to extract, as for \code{\link{head}}.}

\item{...}{ignored}
}
\description{
Extract The Start of an Oce Object

This function handles the following object classes directly:
\code{\link{adp-class}},
\code{\link{adv-class}},
\code{\link{argo-class}} (selection by profile),
\code{\link{coastline-class}},
\code{\link{ctd-class}},
\code{\link{echosounder-class}} (selection by ping),
\code{\link{section-class}} (selection by station)
and
\code{\link{topo-class}} (selection by longitude and latitude).
It does not handle
\code{\link{amsr-class}} or
\code{\link{landsat-class}}
yet, instead issuing a warning and returning \code{x} in those cases.
For all other classes, it calls \code{\link{head}}
with \code{n} as provided, for each item in the \code{data}
slot, issuing a warning if that item is not a vector; the
author is quite aware that this may not work well for all classes.
The plan is to handle all appropriate classes by July 2018.
Please contact the author if there is a class you need handled
before that date.
}
\seealso{
\code{\link{tail.oce}}, which yields the end of an \code{oce} object.
}
\author{
Dan Kelley
}
