% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geod.R
\name{geodXyInverse}
\alias{geodXyInverse}
\title{Inverse Geodesic Calculation}
\usage{
geodXyInverse(x, y, longitudeRef = 0, latitudeRef = 0)
}
\arguments{
\item{x}{value of x in metres, as given by \code{\link{geodXy}}}

\item{y}{value of y in metres, as given by \code{\link{geodXy}}}

\item{longitudeRef}{reference longitude, as supplied to \code{\link{geodXy}}}

\item{latitudeRef}{reference latitude, as supplied to \code{\link{geodXy}}}
}
\value{
a data frame containing \code{longitude} and \code{latitude}
}
\description{
The calculation is done by finding a minimum value of a cost
function that is the vector difference between (\code{x},\code{y})
and the corresponding values returned by \code{\link{geodXy}}. This
minimum is calculated in C for speed, using the \code{nmmin} function
that is the underpinning for the Nelder-Meade version of the R function
\code{\link{optim}}.
}
\seealso{
Other functions relating to geodesy: \code{\link{geodDist}},
  \code{\link{geodGc}}, \code{\link{geodXy}}
}

