% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\name{as.cm}
\alias{as.cm}
\title{Coerce data into a CM object}
\usage{
as.cm(time, u = NULL, v = NULL, pressure = NULL, conductivity = NULL,
  temperature = NULL, salinity = NULL, longitude = NA, latitude = NA,
  filename = "", debug = getOption("oceDebug"))
}
\arguments{
\item{time}{A vector of times of observation, or an \code{oce} object that holds \code{time},
in addition to either both \code{u} and \code{v}, or both \code{directionTrue}
and \code{speedHorizontal}.}

\item{u}{either a numerical vector containing the eastward component of velocity, in m/s,
or an \code{oce} object that can can be coerced into a \code{cm} object. In the second
case, the other arguments to the present function are ignored.}

\item{v}{vector containing the northward component of velocity in m/s.}

\item{pressure}{vector containing pressure in dbar. Ignored if the first argument
contains an \code{oce} object holding pressure.}

\item{conductivity}{Optional vector of conductivity.
Ignored if the first argument contains an \code{oce} object holding pressure.}

\item{temperature}{Optional vector of temperature.
Ignored if the first argument contains an \code{oce} object holding temperature}

\item{salinity}{Optional vector of salinity, assumed to be Practical Salinity.
Ignored if the first argument contains an \code{oce} object holding saliity}

\item{longitude}{Optional longitude in degrees East.
Ignored if the first argument contains an \code{oce} object holding longitude.}

\item{latitude}{Latitude in degrees North.
Ignored if the first argument contains an \code{oce} object holding latitude.}

\item{filename}{Optional source file name}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}
}
\description{
Coerce data into a CM object
}
\seealso{
Other things related to \code{cm} data: \code{\link{[[,cm-method}},
  \code{\link{[[<-,cm-method}}, \code{\link{cm-class}},
  \code{\link{cm}}, \code{\link{plot,cm-method}},
  \code{\link{read.cm}}, \code{\link{subset,cm-method}},
  \code{\link{summary,cm-method}}
}

