% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oXim-main.R
\name{getOxyrange}
\alias{getOxyrange}
\title{Takes a matrix of echogram and calculate Oxycline.}
\usage{
getOxyrange(fluidMatrix, filterSettings = NULL, stepBYstep = FALSE)
}
\arguments{
\item{fluidMatrix}{Object of class \code{echoData} (from \code{\link{readEchograms}} function) with echogram}

\item{filterSettings}{List with combination of filters.}

\item{stepBYstep}{\code{logical}. If \code{FALSE} (default), returns just original and final echogram, otherwise each
echogram (after applying filters one by one) will be returned.}
}
\description{
This function takes a filter configuration and applies to echograms given on an \code{echoData} object.
}
\details{
If \code{filterSettings = NULL}, oXim will use filter configuration present on \code{defaultFilterSettings}
data set. For extra details about image filters, see \code{\link{createFilterSetting}} help.
}
\examples{
fileMode <- list(fish38_file   = system.file("extdata", "fish38.mat", package = "oXim"),
                 fluid120_file = system.file("extdata", "fluid120.mat", package = "oXim"),
                 blue38_file   = system.file("extdata", "blue38.mat", package = "oXim"))
echoData <- readEchograms(fileMode = fileMode)
oxyLimits <- getOxyrange(fluidMatrix = echoData)

}

