% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{plot.hmm_mcmc_normal}
\alias{plot.hmm_mcmc_normal}
\title{Plot Diagnostics for \code{hmm_mcmc_normal} Objects}
\usage{
\method{plot}{hmm_mcmc_normal}(
  x,
  simulation = FALSE,
  true_means = NULL,
  true_sd = NULL,
  true_mat_T = NULL,
  true_states = NULL,
  show_titles = TRUE,
  ...
)
}
\arguments{
\item{x}{(hmm_mcmc_normal) HMM MCMC normal object}

\item{simulation}{(logical) \code{optional parameter}; default is \code{simulation=FALSE}, so the input data was empirical. If the input data was simulated, it must be set \code{simulation=TRUE}.}

\item{true_means}{(numeric) \code{optional parameter}; true means. To be used if \code{simulation=TRUE}}

\item{true_sd}{(numeric) \code{optional parameter}; true standard deviation. To be used if \code{simulation=TRUE}}

\item{true_mat_T}{(matrix) \code{optional parameter}; true transition matrix. To be used if \code{simulation=TRUE}}

\item{true_states}{(integer) \code{optional parameter}; true states. To be used if \code{simulation=TRUE}}

\item{show_titles}{(logical) \code{optional parameter}; if \code{TRUE} then titles are shown for all graphs. By default, \code{TRUE}}

\item{...}{not used}
}
\value{
Several diagnostic plots that can be used to evaluate the MCMC simulation
of the normal HMM
}
\description{
This function creates a variety of diagnostic plots that can be useful when 
conducting Markov Chain Monte Carlo (MCMC) simulation of a normal hidden Markov model (HMM). 
These plots will help to assess convergence, fit, and performance of the MCMC simulation
}
\examples{
\donttest{
plot(example_hmm_mcmc_normal)
}
}
