% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getDictionaryEntries}
\alias{getDictionaryEntries}
\title{Lookup entries in a dictionary.}
\usage{
getDictionaryEntries(labbcat.url, managerId, dictionaryId, keys)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{managerId}{The layer manager ID of the dictionary, as returned by getDictionaries}

\item{dictionaryId}{The ID of the dictionary, as returned by getDictionaries}

\item{keys}{A list of entries to look up}
}
\value{
A data frame with the keys and their dictionary entries.
}
\description{
Lookup entries in a dictionary.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

keys <- c("the", "quick", "brown", "fox")

## get the pronunciations according to CELEX
entries <- getDictionaryEntries(labbcat.url, "CELEX-EN", "Phonology (wordform)", keys)
}

}
\seealso{
\link{getDictionaries}
}
\keyword{dictionary}
