% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getAnnotationLabels}
\alias{getAnnotationLabels}
\title{Gets labels of annotations on a given layer, identified by given annotation IDs.}
\usage{
getAnnotationLabels(labbcat.url, id, layerId, count = 1,
  no.progress = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A vector of annotation IDs.}

\item{layerId}{A layer name.}

\item{count}{The number of annotations on the given layer to retrieve.}

\item{no.progress}{Optionally suppress the progress bar when
multiple fragments are  specified - TRUE for no progress bar.}
}
\value{
A data frame of labels.
}
\description{
Gets labels of annotations on a given layer, identified by given annotation IDs.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## specify the username/password in the script
## (only use labbcatCredentials for scripts that must execute unsupervised!)
labbcatCredentials(labbcat.url, "demo", "demo")

## Load some serach results, normally something like:
##  results <- read.csv("results.csv", header=T)
## ...but for demonstration purposes:
results <- data.frame(
             id=c("AP513_Steve.eaf", "AP513_Steve.eaf", "AP513_Steve.eaf"),
             MatchId=c("g_6;em_12_419;n_9243-n_9245;p_14;#=ew_0_7260;[0]=ew_0_7260",
                       "g_6;em_12_429;n_9263-n_9265;p_14;#=ew_0_7487;[0]=ew_0_7487",
                       "g_6;em_12_440;n_9285-n_9287;p_14;#=ew_0_7704;[0]=ew_0_7704"))

## Get the topic annotations for the matches
topics <- getAnnotationLabels(labbcat.url, results$MatchId, "topic")
}

}
\keyword{annotation}
\keyword{label}
\keyword{layer}
