% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_tree_census_2015.R
\name{nyc_tree_census_2015}
\alias{nyc_tree_census_2015}
\title{NYC 2015 Street Tree Census - Tree Data}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/uvpi-gqnh>
}
\usage{
nyc_tree_census_2015(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing 2015 Street Tree Census - Tree Data.
}
\description{
Downloads 2015 Street Tree Census - Tree Data from NYC Open Data.
}
\details{
This dataset contains records from the 2015 Street Tree Census,
including species, health, and location information for each recorded tree.
Data collected by NYC Parks and volunteers.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_tree_census_2015(limit = 10)
head(small_sample)

\donttest{
nyc_tree_census_2015(limit = 5000)
nyc_tree_census_2015(filters = list(curb_loc = "OnCurb"))
}
}
