% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.r
\name{query_api}
\alias{query_api}
\title{query_api
Makes a query to the Canadian Nutrient Files API.}
\usage{
query_api(path, apiKey = NULL, id = NULL, lang = "en")
}
\arguments{
\item{path}{the path to the desired endpoint. (Should be one of food, nutrientamount
nutrientgroup, nutrientname, nutrientsource, refuseamount, servingsize, or yieldamount.)}

\item{apiKey}{key to access the API. Can be retrieved from \url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, @seealso \code{\link[=get_key]{get_key()}} will check the system environments for one.}

\item{id}{the id of what you're looking for. Meaning of the id changes depending on endpoint.}

\item{lang}{the language you are using and want results returned in.}
}
\value{
a structure with the parsed text response, the raw response, the endpoint path, and the id.
}
\description{
query_api
Makes a query to the Canadian Nutrient Files API.
}
\examples{
\dontrun{
query_api("food")
query_api("food", id = 2314)
query_api("nutrientgroup", id = 1)
query_api("nutrientname", id = 1)
query_api("nutrientsource", id = 82)
query_api("refuseamount", id = 2314)
query_api("servingsize", id = 2314)
query_api("yieldamount", id = 2314)
}
}
\references{
Note that this function is based on, and repeats much of the code in
the R API package best practices,
available at \url{https://httr.r-lib.org/articles/api-packages.html#overall-design-1}.
}
