% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_refuseamount}
\alias{get_refuseamount}
\title{get_refuseamount}
\usage{
get_refuseamount(apiKey = NULL, foodCode = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{foodCode}{The code indicating the food you want to search for. If null,
all foods and their corresponding refuse amounts are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing refuse name, refuse amount, food names and food codes.
}
\description{
Makes a query to the Canadian Nutrient File refuseamount endpoint. This endpoint returns
a list of refuse amounts and name as well as the corresponding food code and description.
Refuse amounts correspond to the inedible portion of the food. For instance, searching for
food code 557 (Chicken, broiler, meat, skin, giblets and neck) will return
a refuse amount of 28 and its associated name is 'bone'.
}
\examples{
\dontrun{
get_refuseamount()
get_refuseamount(foodCode = 557)
get_refuseamount(foodCode = 557, lang = "fr")}
}
