\name{jacobian}
\alias{jacobian}
\alias{jacobian.default}
\title{Gradient of a Vector Valued Function}
\description{
Calculate the m by n numerical approximation of the gradient of a real
m-vector valued function with n-vector argument.
}
\usage{
    jacobian(func, x, method="Richardson", method.args=list(), ...) 

    \method{jacobian}{default}(func, x, method="Richardson",
       method.args=list(eps=1e-4, d=0.0001, 
       zero.tol=sqrt(.Machine$double.eps/7e-7), r=4, v=2, show.details=FALSE), ...)
}
\arguments{
    \item{func}{a function with a real (vector) result.}
    \item{x}{a real or real vector argument to func, indicating the point 
       at which the gradient is to be calculated.}
    \item{method}{one of \code{"Richardson"} or \code{"simple"} indicating 
    the method to use for the approximation.}
    \item{method.args}{arguments passed to method. See \code{\link{grad}}. 
       (Arguments not specified remain with their default values.)}
    \item{...}{any additional arguments passed to \code{func}.}
}
\value{A real m by n matrix.}
\details{
   For \eqn{f:R^n -> R^m}{f:R^n -> R^m} calculate the \eqn{m x n}{m x n} 
   Jacobian \eqn{dy/dx}{dy/dx}.
   The function \code{jacobian} calculates a numerical approximation of the 
   first derivative of \code{func} at the point \code{x}. Any additional 
   arguments in \dots are also passed to \code{func}, but the gradient is not
   calculated with respect to these additional arguments.
   
   If method is "simple", the calculation is done using a simple epsilon
   difference. For this case, only the \code{methods.args} element \code{eps}
   is used. If method is "Richardson", the calculation is done by 
   Richardson's extrapolation. See \code{link{grad}} for more details.
}

\seealso{
  \code{\link{grad}},
  \code{\link{hessian}},
  \code{\link[stats]{numericDeriv}}
  }
\examples{
   func2 <- function(x) c(sin(x), cos(x))
   x <- (0:1)*2*pi
   jacobian(func2, x)
}
\keyword{multivariate}
