% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsbeta.R
\name{Neutrosophic Beta}
\alias{Neutrosophic Beta}
\alias{dnsbeta}
\alias{pnsbeta}
\alias{qnsbeta}
\alias{rnsbeta}
\title{Neutrosophic Beta Distribution}
\usage{
dnsbeta(x, shape1, shape2)

pnsbeta(q, shape1, shape2, lower.tail = TRUE)

qnsbeta(p, shape1, shape2)

rnsbeta(n, shape1, shape2)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{shape1}{the first shape parameter, which must be a positive interval.}

\item{shape2}{the second shape parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsbeta} gives the distribution function,
\code{dnsbeta} gives the density,
\code{qnsbeta} gives the quantile function and
\code{rnsbeta} generates random values from the neutrosophic Beta distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the nuetrosophic Beta distribution with shape parameters
\code{shape1} = \eqn{\alpha_N} and \code{shape2} = \eqn{\beta_N}.
}
\details{
The neutrosophic beta distribution with parameters \eqn{\alpha_N} and
\eqn{\beta_N} has the probability density function
\deqn{f_N(X) = \frac{1}{B(\alpha_N, \beta_N)} X^{\alpha_N - 1} (1 - X)^{\beta_N - 1}}
for \eqn{\alpha_N \in (\alpha_L, \alpha_U)}, the first shape parameter which
must be a positive interval, and \eqn{\beta_N \in (\beta_L, \beta_U)},
the second shape parameter which must also be a positive interval, and
\eqn{0 \le x \le 1}. The function \eqn{B(a, b)}
returns the beta function and can be calculated using \code{\link{beta}}.
}
\examples{

dnsbeta(x = c(0.1, 0.2), shape1 = c(1, 1), shape2 = c(2, 2))
dnsbeta(x = 0.1, shape1 = c(1, 1), shape2 = c(2, 2))

x <- matrix(c(0.1, 0.1, 0.2, 0.3, 0.5, 0.5), ncol = 2, byrow = TRUE)
dnsbeta(x, shape1 = c(1, 2), shape2 = c(2, 3))


pnsbeta(q = c(0.1, 0.1), shape1 = c(3, 1), shape2 = c(1, 3), lower.tail = FALSE)
pnsbeta(x, shape1 = c(1, 2), shape2 = c(2, 2))


qnsbeta(p = 0.1, shape1 = c(1, 1), shape2 = c(2, 2))
qnsbeta(p = c(0.25, 0.5, 0.75), shape1 = c(1, 2), shape2 = c(2, 2))

# Simulate 10 numbers
rnsbeta(n = 10, shape1 = c(1, 2), shape2 = c(1, 1))
}
\references{
Sherwani, R. Ah. K., Naeem, M., Aslam, M., Reza, M. A., Abid, M., Abbas, S. (2021).
    Neutrosophic beta distribution with properties and applications.
    \emph{Neutrosophic Sets and Systems}, 41, 209-214.
}
