% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsir.R
\name{gsir}
\alias{gsir}
\title{gsir}
\usage{
gsir(x,x.new,y,ytype,ex,ey,complex.x,complex.y,r)
}
\arguments{
\item{x}{input predictor matrix from training set}

\item{x.new}{input predictor matrix from testing set}

\item{y}{response variables}

\item{ytype}{type of response variables}

\item{ex}{tuning parameter for the Tychonoff regularized inverse for GX}

\item{ey}{tuning parameter for the Tychonoff regularized inverse for GY}

\item{complex.x}{tuning parameter for the Gaussian kernel in X}

\item{complex.y}{tuning parameter for the Gaussian kernel in Y}

\item{r}{number of dimension}
}
\value{
suff.pred: sufficient predictors from GSIR

obj.mat: objective matrix of GSIR

eig.val: the first r eigenvalues from the eigendecomposition of the objective matrix

eig.vec: the first r eigenvectors from the eigendecomposition of the objective matrix
}
\description{
gsir
}
\examples{

n = 50; p = 5; sigma = 1;
x = matrix(rnorm(n*p),n,p) ; err = rnorm(n)
y = sin(0.5+(x[,1]+1)^2) + sigma*err; ex=0.01 ; ey=0.01
gsir_res <- gsir(x,x,y,"scalar",ex,ey,1,1,1)
}
\references{
Li, B. (2018). Sufficient dimension reduction: Methods and applications with R. CRC Press.
}
