% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test_vs_external_estimates.R
\name{chisq_test_vs_external_estimate}
\alias{chisq_test_vs_external_estimate}
\title{Test of differences in survey percentages relative to external estimates}
\usage{
chisq_test_vs_external_estimate(survey_design, y_var, ext_ests, na.rm = TRUE)
}
\arguments{
\item{survey_design}{A survey design object created with the \code{survey} package.}

\item{y_var}{Name of dependent categorical variable.}

\item{ext_ests}{A numeric vector containing the external estimate of the percentages for each category.
The vector must have names, each name corresponding to a given category.}

\item{na.rm}{Whether to drop cases with missing values}
}
\value{
A data frame containing the results of the Chi-Square test(s) of whether survey-based estimates systematically differ from external estimates.
\cr
\cr
The columns of the output dataset include: \cr
\itemize{
\item \code{statistic}: The value of the test statistic \cr
\item \code{df}: Degrees of freedom for the reference Chi-Squared distribution \cr
\item \code{scale}: Estimated scale parameter.
\item \code{p_value}: The p-value of the test of independence \cr
\item \code{test_method}: Text giving the name of the statistical test
\item \code{variance_method}: Text describing the method of variance estimation
}
}
\description{
Compare estimated percentages from the present survey to external estimates from a benchmark source.
A Chi-Square test with Rao-Scott's second-order adjustment is used to evaluate whether the survey's estimates differ from the external estimates.
}
\details{
Please see \link[survey]{svygofchisq} for details of how the Rao-Scott second-order adjusted test is conducted.
The test statistic, \code{statistic} is obtained by calculating the Pearson Chi-squared statistic for the estimated table of population totals. The reference distribution is a Satterthwaite approximation. The p-value is obtained by comparing \code{statistic}/\code{scale} to a Chi-squared distribution with \code{df} degrees of freedom.
}
\examples{

library(survey)

# Create a survey design ----
data("involvement_survey_pop", package = "nrba")
data("involvement_survey_str2s", package = "nrba")

involvement_survey_sample <- svydesign(
  data = involvement_survey_str2s,
  weights = ~BASE_WEIGHT,
  strata = ~SCHOOL_DISTRICT,
  ids = ~ SCHOOL_ID + UNIQUE_ID,
  fpc = ~ N_SCHOOLS_IN_DISTRICT + N_STUDENTS_IN_SCHOOL
)

# Subset to only include survey respondents ----

involvement_survey_respondents <- subset(
  involvement_survey_sample,
  RESPONSE_STATUS == "Respondent"
)

# Test whether percentages of categorical variable differ from benchmark ----

parent_email_benchmark <- c(
  "Has Email" = 0.85,
  "No Email" = 0.15
)

chisq_test_vs_external_estimate(
  survey_design = involvement_survey_respondents,
  y_var = "PARENT_HAS_EMAIL",
  ext_ests = parent_email_benchmark
)

}
\references{
\itemize{
\item Rao, JNK, Scott, AJ (1984) "On Chi-squared Tests For Multiway Contigency Tables with Proportions Estimated From Survey Data" Annals of Statistics 12:46-60. \cr
}
}
