#' Copyright(c) 2017-2020 R. Mark Sharp
#' This file is part of nprcgenekeepr
context("convertSexCodes")
library(testthat)
original <- c("m", "male", "1", "MALE", "M", "F", "f", "female", "FemAle", "U",
              "Unknown", "H", "hermaphrodite", "U", "Unknown", "3", "4")
sexCodes <- convertSexCodes(original)
test_that("convertSexCodes makes correct transformations", {
  expect_true(is.factor(sexCodes))
  sexCodes <- as.character(sexCodes)
  expect_equal(sexCodes[1], "M")
  expect_equal(sexCodes[2], "M")
  expect_equal(sexCodes[3], "M")
  expect_equal(sexCodes[4], "M")
  expect_equal(sexCodes[5], "M")
  expect_equal(sexCodes[6], "F")
  expect_equal(sexCodes[7], "F")
  expect_equal(sexCodes[8], "F")
  expect_equal(sexCodes[9], "F")
  expect_equal(sexCodes[10], "U")
  expect_equal(sexCodes[11], "U")
  expect_equal(sexCodes[12], "U")
  expect_equal(sexCodes[13], "U")
  expect_equal(sexCodes[14], "U")
  expect_equal(sexCodes[15], "U")
  expect_equal(sexCodes[16], "U")
  expect_equal(sexCodes[17], "U")
  sexCodes <- convertSexCodes(original, ignoreHerm = FALSE)
  sexCodes <- as.character(sexCodes)
  expect_equal(sexCodes[12], "H")
  expect_equal(sexCodes[13], "H")
  expect_equal(sexCodes[13], "H")
  expect_equal(sexCodes[17], "H")
})
