% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeRelationsClassesTable.R
\name{makeRelationClassesTable}
\alias{makeRelationClassesTable}
\title{Make relation classes table from \code{kin} dataframe.}
\usage{
makeRelationClassesTable(kin)
}
\arguments{
\item{kin}{a dataframe with columns \code{id1}, \code{id2}, \code{kinship},
and \code{relation}. It is a long-form table of pairwise kinships, with
relationship categories included for each pair.}
}
\value{
A data.frame with the number of instances of following relationship
classes: Parent-Offspring, Full-Siblings, Half-Siblings,
Grandparent-Grandchild, Full-Cousins, Cousin - Other, Full-Avuncular,
Avuncular - Other, Other, and No Relation.
}
\description{
From Relations
}
\examples{
\donttest{
library(nprcgenekeepr)
suppressMessages(library(dplyr))

qcPed <- nprcgenekeepr::qcPed
bkmat <- kinship(qcPed$id, qcPed$sire, qcPed$dam, qcPed$gen,
                 sparse = FALSE)
kin <- convertRelationships(bkmat, qcPed)
relClasses <- makeRelationClassesTable(kin)
relClasses$`Relationship Class` <-
   as.character(relClasses$`Relationship Class`)
relClassTbl <- kin[!kin$relation == "Self", ] \%>\%
  group_by(relation) \%>\%
  summarise(count = n())
relClassTbl
}

}
