% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext.R
\name{replext}
\alias{replext}
\title{Replext Simulation Shiny App}
\usage{
replext()
}
\description{
This application attempts to replicate and extend the simulation results from
the paper by Dwivedi et al. (2017). The application includes a user interface
for selecting simulation parameters and a server logic to process the simulation
and handle user interactions.
}
\details{
The app's user interface consists of:
\itemize{
\item A numeric input for setting an optional random number seed.
\item A dropdown menu to select a cell block for the simulation, which is
populated using the \code{getCellBlocks} function.
\item Dynamic UI elements for inputting simulation parameters, generated
based on the selected cell block.
\item A button to run the simulation.
\item A download button to export the simulation results.
}

The server logic of the app handles:
\itemize{
\item Rendering the dynamic UI elements for simulation parameters.
\item Observing the simulation run event and processing the simulation
using the \code{runSimulation} function.
\item Rendering a table to display the simulation results.
\item Handling the data download request and exporting the results as a CSV file.
}
}
\examples{
if(interactive()){
  replext()
}

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size studies using nonparametric bootstrap test with pooled resampling method. Stat Med. 2017 Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
