% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_create_field_notes_template.R
\name{create_field_notes_template}
\alias{create_field_notes_template}
\alias{create_fieldnotes_template}
\title{Create a template for refinement field notes}
\usage{
create_field_notes_template(path = stop("A save path must be specified."))

create_fieldnotes_template(path = stop("A save path must be specified."))
}
\arguments{
\item{path}{(Character) The path where the field notes template should
be created.}
}
\value{
Invisibly returns the path to the template (Character). In an
interactive session, also opens \code{path} in the system's file viewer.
}
\description{
It is good practice to record when refinements were made, what was done, and
the reasons behind them. These "field notes" are used by this package to
annotate plots created by \code{\link[=plot_novelty]{plot_novelty()}} and \code{\link[=plot_richness]{plot_richness()}}, and they're
also requested by peer reviewers as part of the publication process.

This template contains 5 columns (only the first one, \code{interview_num},
is currently used by the package, but this is subject to change):
\enumerate{
\item \code{interview_num} is the upcoming interview number where these refinements
will take effect.
\item \code{refinement_type} is free text describing the kind of refinement,
e.g. "add" or "rephrase" or "remove".
\item \code{refinement} is the actual text that has been changed.
\item \code{reason} describes the rationale behind the refinement.
\item \code{other} is for additional information you may want to include.
}
}
\examples{
\donttest{
# Create the template in a temporary directory.
create_field_notes_template(path = tempdir())
}

}
