% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_test.R
\name{rp.test}
\alias{rp.test}
\title{The k random projections test for normality.}
\usage{
rp.test(y, k = 1, FDR = TRUE, pars1 = c(100,1), pars2  = c(2,7),
               seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a
stationary time series.}

\item{k}{an integer that determines the `2k` random projections are used for
every type of test. The `pars1` argument generates the first `k` projections,
and `pars2` generates the later `k` projections. By default, \code{k = 1}.}

\item{FDR}{a logical value for mixing the p.values using a False discovery
rate method. If \code{FDR = TRUE}, then the p.values are mixed using Benjamin
and Yekutieli (2001) False discovery Rate method for dependent procedures, on
the contrary, it applies Benjamini and Hochberg (1995) procedure.
By default, \code{FDR = TRUE}.}

\item{pars1}{an optional real vector with the shape parameters of the beta
distribution used for the first `k` random projections By default,
\code{pars1 = c(100,1)} where, \code{shape1 = 100} and \code{shape2 = 1}.}

\item{pars2}{an optional real vector with the shape parameters of the beta
distribution used to compute the last `k` random projections. By default,
\code{pars2 = c(2,7)} where, \code{shape1 = 2} and \code{shape2 = 7}.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{an integer value with the amount of projections per test.}
 \item{parameter:}{a text that specifies the p.value mixing FDR method.}
 \item{p.value:}{the FDR mixed p-value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string \dQuote{k random projections test}.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Performs the random projection test for normality. The null hypothesis (H0)
is that the given data follows a stationary Gaussian process.
}
\details{
The random projection test generates `2k` random projections of `y`. Applies
Epps statistics to the odd projections and Lobato and Velasco’s statistics to
the even ones. Computes the `2k` p.values using an asymptotic chi-square distribution
with two degrees of freedom. Finally, mixes the p.values using a false discover
rate procedure. By default, mixes the p.values using Benjamin and Yekutieli’s
(2001) method.

The function uses beta distributions for generating the `2k` random projections.
By default, uses a \code{beta(shape1 = 100,shape = 1)} distribution contained
in \code{pars1} argument to generate the first `k` projections. For the later
`k` projections the functions uses a \code{beta(shape1 = 2,shape = 7)} distribution
contained in \code{pars2} argument.

The test was proposed by \emph{Nieto-Reyes, A.,Cuesta-Albertos, J. & Gamboa,
F. (2014)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
rp.test(y)

}
\references{
Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.

Benjamini, Y., and Yekutieli, D. (2001). The control of the false discovery rate in
multiple testing under dependency. \emph{Annals of Statistics}. 29, 1165–1188.
Doi:10.1214/aos/1013699998.

Hochberg, Y. (1988). A sharper Bonferroni procedure for multiple tests of significance.
\emph{Biometrika}. 75, 800–803. Doi:10.2307/2336325.

Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.
}
\seealso{
\code{\link{lobato.test}}, \code{\link{epps.test}}
}
\author{
Asael Alonzo Matamoros and Alicia Nieto-Reyes.
}
