% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{grid.sim}
\alias{grid.sim}
\title{Combine fix grid and simulated grid based on multivariate normal distribution}
\usage{
grid.sim(n, means = NULL, sigma, grid.param = NULL, pure.sim = FALSE)
}
\arguments{
\item{n}{Number of simulations}

\item{means}{vector of mean values}

\item{sigma}{covariance matrix}

\item{grid.param}{the index of the parameter for which a fix grid (from qnorm) is used instead of a simulated grid (rnorm).
If grid.param=NULL ( default) the fix grid will be used for the parameter with largest variance.}

\item{pure.sim}{do pure simulation for all parameters, default=FALSE}
}
\value{
row-matrix of parameters
}
\description{
grid.sim produce comparable output to mvnorm however with one column having a fixed range of values rather than a
simulated range of values. As the number of simulations (n) goes to infinity grid.sim is identical to mvnorm in
that the covariance of the output's both will converge to the input covariance matrix sigma.
The advantage with grid.sim is that the function provides more stable results, hence number of simulations can
be reduced and still have equally stable results when used to represent parameter uncertainty and or population variability
in model predictions.
}
\examples{
sigma<-matrix(c(1,0.5,0.5,2),ncol=2)
sim1<-grid.sim(1000,sigma=sigma)
pairs(sim1)
cov(sim1)
}

