% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinearTests.R
\name{thresholdTest}
\alias{thresholdTest}
\title{Threshold nonlinearity test}
\usage{
thresholdTest(
  time.series,
  p,
  d = 1,
  lower.percent = 0.25,
  upper.percent = 0.75
)
}
\arguments{
\item{time.series}{The original time.series.}

\item{p}{The order of the AR process.}

\item{d}{Delay used for the threshold value in the TAR process.}

\item{lower.percent}{The threshold value is searched over an interval 
defined by \emph{lower.percent} and \emph{upper.percent} of the time series
values. This defines the lower percent.}

\item{upper.percent}{The threshold value is searched over an interval 
defined by \emph{lower.percent} and \emph{upper.percent} of the time series
values. This defines the upper percent.}
}
\value{
A list containing
\itemize{
   \item p.value: p-value of the test
   \item test.statistic: Likelihood ratio test statistic.
   \item percentiles: Since the search for the threshold parameter may 
   occur in a narrower interval than the one specified by the user, the
   effective lower and upper percents are returned here.
}
}
\description{
Computes the likelihood ratio test for threshold nonlinearity 
with H0 being an AR process and H1 a TAR model.
}
\note{
Adapted from the \emph{tlrt} function of the \emph{TSA} package.
}
\references{
Chan, K.S. (1990). Percentage points of likelihood ratio tests 
for threshold autoregression. Journal of Royal Statistical Society,
B 53, 3, 691-696.
}
\seealso{
\code{\link{nonlinearityTest}}, \code{\link{keenanTest}},
 \code{\link{tsayTest}}, \code{\link{mcleodLiTest}}
}
\author{
Kung-Sik Chan
}
