% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_lite_sf.R
\name{geo_lite_sf}
\alias{geo_lite_sf}
\title{Get spatial objects through geocoding}
\usage{
geo_lite_sf(
  address,
  limit = 1,
  return_addresses = TRUE,
  full_results = FALSE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{address}{single line address (i.e. \code{"1600 Pennsylvania Ave NW, Washington"}) or a vector of addresses (\code{c("Madrid", "Barcelona")}).}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{return_addresses}{return input addresses with results if TRUE. Note that
most services return the input addresses with \code{full_results = TRUE} and setting
return_addresses to FALSE does not prevent this.}

\item{full_results}{returns all data from the geocoder service if TRUE.
If FALSE then only longitude and latitude are returned from the geocoder service.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (i.e. \code{list(countrycodes = "US")}). See Details.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial points (\code{TRUE}, which is the default) or potentially other shapes as provided by the Nominatim API (\code{FALSE}).}
}
\value{
A \code{sf} object with the results.
}
\description{
This function allows you to geocode addresses and return the corresponding
spatial object.

The parameter \code{points_only} specifies whether the function results will be points (all Nominatim results are guaranteed to have at least point geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE} will depend on the object being geocoded:
\itemize{
\item administrative areas, major buildings and the like will be returned as polygons
\item rivers, roads and their like as lines
\item amenities may be points even in case of a \code{points_only = FALSE} call
}

The function is vectorized, allowing for multiple addresses to be geocoded; in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}
\details{
See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\examples{
\donttest{
# Map - Points
library(ggplot2)
pentagon <- geo_lite_sf("Pentagon")


ggplot(pentagon) +
  geom_sf()

pentagon_poly <- geo_lite_sf("Pentagon", points_only = FALSE)

ggplot(pentagon_poly) +
  geom_sf()

# Several results

Madrid <- geo_lite_sf("Madrid",
  limit = 2,
  points_only = FALSE, full_results = TRUE
)


ggplot(Madrid) +
  geom_sf(fill = NA)

Starbucks <- geo_lite_sf("Starbucks, New York",
  limit = 20, full_results = TRUE
)


ggplot(Starbucks) +
  geom_sf()
}
}
\seealso{
\code{\link[=geo_lite]{geo_lite()}}

Other spatial: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{spatial}
