% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbShow}
\alias{dbShow}
\alias{dbShow,AthenaConnection-method}
\title{Show Athena table's DDL}
\usage{
dbShow(conn, name, ...)

\S4method{dbShow}{AthenaConnection}(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbShow()} returns \code{\link[DBI]{SQL}} characters of the Athena table DDL.
}
\description{
Executes a statement to return the data description language (DDL) of the Athena table.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())
                 
# write iris table to Athena                  
dbWriteTable(con, "iris",
             iris,
             partition = c("timestamp" = format(Sys.Date(), "\%Y\%m\%d")),
             s3.location = "s3://path/to/store/athena/table/")

# return table ddl
noctua::dbShow(con, "iris")

# disconnect from Athena
dbDisconnect(con)
}
}
