% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{Qsym.test}
\alias{Qsym.test}
\title{Pielou's Second Type of NN Symmetry Test with Chi-square Approximation}
\usage{
Qsym.test(x, lab, is.ipd = TRUE, combine = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix (IPD matrix), otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{combine}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, 
the cells in column 3 or columns to the left are merged in the QCT, so \eqn{Q_2}, \eqn{Q_3} etc. are pooled, so the column
labels are \eqn{Q_0}, \eqn{Q_1} and \eqn{Q_2} with the last one is actually sum of \eqn{Q_j} for \eqn{j \ge 2} in the QCT. 
If \code{FALSE}, the function does not perform the pooling of the cells.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for Pielou's second type of NN symmetry test (i.e., \eqn{Q}-symmetry 
which is equivalent to symmetry in the shared NN structure)}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{(k-1)(n_c-1)} where \eqn{n_c} is the number of
columns in QCT (which reduces to \eqn{2(k-1)} if \code{combine=TRUE}).}
\item{estimate}{Estimates, i.e., the observed QCT.}
\item{est.name,est.name2}{Names of the estimates, they are identical for this function.}
\item{null.value}{Hypothesized null values for the entries of the QCT, i.e., the matrix with entries 
\eqn{E(Q_{ij})=n_i Q_j/n} where \eqn{n_i} the size of class \eqn{i} and \eqn{Q_j} is the sum of column \eqn{j} in the QCT (i.e., the total
number of points serving as NN to class \eqn{j} other points).}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{x}}
}
\description{
An object of class \code{"Chisqtest"} performing the hypothesis test of equality of the probabilities for the rows
in the \eqn{Q}-symmetry contingency table (QCT).
Each row of the QCT is the vector of Qi\eqn{j} values where \eqn{Q_{ij}} is the number of class \eqn{i} points that are NN
to \eqn{j} points.
That is, the test performs Pielou's second type of NN symmetry test which is also equivalent to Pearson's
test on the QCT (\insertCite{pielou:1961;textual}{nnspat}).
Pielou's second type of NN symmetry is the symmetry in the shared NN structure for all classes, which is also 
called \eqn{Q}-symmetry.
The test is appropriate (i.e. have the appropriate asymptotic sampling distribution)
provided that data is obtained by sparse sampling, although simulations suggest it seems to work for
completely mapped data as well.
(See \insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.

The argument combine is a logical argument (default=\code{TRUE}) to determine whether to combine the 3rd column 
and the columns to the left.
If \code{TRUE}, this function pools the cells 3 or larger together for \eqn{k} classes in the QCT, 
so \eqn{Q_2}, \eqn{Q_3} etc. are pooled, so the column
labels are \eqn{Q_0}, \eqn{Q_1} and \eqn{Q_2} with the last one is actually sum of \eqn{Q_j} for \eqn{j \ge 2} in the QCT.
If \code{FALSE}, the function does not perform the pooling of the cells.

The function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{(k-1)(n_c-1)} where \eqn{n_c} is the number of
columns in QCT (which reduces to \eqn{2(k-1)}, if \code{combine=TRUE}). It also provides the description of
the alternative with the corresponding null values (i.e. expected values) of the entries of the QCT and also the sample estimates 
of the entries of QCT (i.e., the observed QCT).
The function also provides names of the test statistics, the method and the data set used.

The null hypothesis is the symmetry in the shared NN structure for each class, that is,
all \eqn{E(Q_{ij})=n_i Q_j/n} where \eqn{n_i} the size of class \eqn{i} and \eqn{Q_j} is the sum of column \eqn{j} 
in the QCT (i.e., the total number of points serving as NN to class \eqn{j} other points). (i.e., symmetry in the 
mixed NN structure).

See also
(\insertCite{pielou:1961,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)
Qsym.ct(ipd,cls)

Qsym.test(ipd,cls)
Qsym.test(Y,cls,is.ipd = FALSE)
Qsym.test(Y,cls,is.ipd = FALSE,method="max")

Qsym.test(ipd,cls,combine = FALSE)

#cls as a faqctor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Qsym.test(ipd,fcls)
Qsym.test(Y,fcls,is.ipd = FALSE)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

Qsym.test(ipd,cls)
Qsym.test(Y,cls,is.ipd = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym}} and \code{\link{Xsq.nnsym}}
}
\author{
Elvan Ceyhan
}
