% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.nlstac.R
\name{predict.nlstac}
\alias{predict.nlstac}
\title{Predict a nls tac fit.}
\usage{
\method{predict}{nlstac}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"tac"} obtained by the \code{nls_tac} function.}

\item{newdata}{An optional data frame in which to look for variables with which to predict. It should contain
at least the columns for the independent variables with the same names as the ones used in the formula passed to the
\code{nls_tac} function. If omitted, the fitted values are used.}

\item{...}{Ignored, for compatibility issues.}
}
\value{
A vector with the predicted values for the predictor given in the \code{newdata} input.
}
\description{
Returns the prediction values of a nls tac fit model for a given set of predictors.
}
\examples{


x <- seq(from = 0, to = 3, length.out = 50)
y <- 3*exp(-5*x) + 2*x + 1 + 0.05*rnorm(50)
df <- data.frame(x = x, y = y)
form <- y ~ a1*exp(-b1*x) + a2*x + a3
nlbnds <- list(b1 = c(0.5,10)) # bouds for tac
fitmodel <-  nls_tac(formula = form, data = df, nlparam = nlbnds)
yhat <- predict(fitmodel) # predict values in the fitted abcisae
plot(x,y)
lines(x,yhat, col = "red", lwd = 2)
# Predicting for other points
newdata <- c(0.25,1.5,2.25)
yhat2 <- predict(fitmodel, newdata = data.frame(x = newdata))
points(newdata, yhat2, pch = 19, col = "blue", cex = 1.2)

}
\author{
\strong{Mariano Rodríguez-Arias} (\email{arias@unex.es}).
\emph{Deptartment of Mathematics}

\strong{Juan Antonio Fernández Torvisco} (\email{jfernandck@alumnos.unex.es}).
\emph{Department of Mathematics}

University of Extremadura (Spain)

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
