% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_nl.R
\name{export_nl}
\alias{export_nl}
\title{Export NetLogo Experiment}
\usage{
export_nl(nl, path = dirname(getnl(nl, "modelpath")), tarfile)
}
\arguments{
\item{nl}{nl object}

\item{path}{Path to folder that contains files to run NetLogo experiment}

\item{tarfile}{Path to folder where the experiments gets stored as zip file}
}
\value{
The status value returned by the external command, invisibly.
}
\description{
Export NetLogo Experiment as zip file
}
\details{
Exports your folder that contains data and scripts for NetLogo + nlrx analyses
as a zip file. Furthermore, \code{export_nl} takes your nl object and saves it in the
zipped folder. This enables other person to run the same experiment as you.
}
\examples{
\donttest{

# Load nl object from testdata:
nl <- nl_lhs
path <- getwd() # adjust path to your needs, path should point to a directory with model data
outfile <- tempfile(fileext = ".zip") # adjust file path to your needs
export_nl(nl, path = path, tarfile = outfile)
}
}
