% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_functions.R
\name{boot_auc}
\alias{boot_auc}
\title{Compute the bootstrap-corrected estimator of AUC.}
\usage{
boot_auc(Y, X, B = 500, learner = "glm_wrapper", correct632 = FALSE,
  ...)
}
\arguments{
\item{Y}{A numeric vector of outcomes, assume to equal \code{0} or \code{1}.}

\item{X}{A \code{data.frame} of variables for prediction.}

\item{B}{The number of bootstrap samples.}

\item{learner}{A wrapper that implements the desired method for building a 
prediction algorithm. See \code{?glm_wrapper} or read the package vignette
for more information on formatting \code{learner}s.}

\item{correct632}{A boolean indicating whether to use the .632 correction.}

\item{...}{Other options, not currently used.}
}
\value{
A list with \code{$auc} as the bootstrap-corrected AUC estimate and 
\code{$n_valid_boot} as the number of bootstrap of bootstrap samples where \code{learner} 
successfully executed.
}
\description{
This estimator is computed by re-sampling with replacement (i.e., bootstrap
sampling) from the data. The AUC is computed for the learner trained on the 
full data. The AUC is then computed for the learner trained on each bootstrap
sample. The average difference between the full data-trained learner and 
the bootstrap-trained learner is computed to estimate the bias in the full-data-estimated
AUC. The final estimate of AUC is given by the difference in the full-data AUC 
and the estimated bias.
}
\examples{
# simulate data
X <- data.frame(x1 = rnorm(50))
Y <- rbinom(50, 1, plogis(X$x1))
# compute lpo_auc for logistic regression 
# use small B for fast run
boot <- boot_auc(Y = Y, X = X, B = 25, learner = "glm_wrapper")

}
