### $Id: Relaxin.R,v 1.1 2000/03/17 22:21:21 saikat Exp $
### Assays of the drug relaxin
### Fei, Gross, Lofgren, Mora-Worms and Chen (1990), Biochem and Biophys
### Research Comm. 170, 214-222.  Also cited in section 1.1.4 of Davidian
### and Giltinan (1995).
"Relaxin" <-
  structure(list
  (Run = structure(ordered(c(8, 8, 8, 8, 8, 8, 8, 
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 
     7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3), levels=1:9),
     class = c("ordered", "factor"),
     .Label = c("5", "8", "9", "3", "4", "2", "7", "1", "6")),
   conc = c(0.085, 0.34, 
     0.34, 0.34, 0.69, 0.69, 0.69, 1.38, 1.38, 1.38, 2.75, 2.75, 2.75, 
     5.5, 5.5, 5.5, 11, 11, 11, 22, 22, 22, 0.085, 0.34, 0.34, 0.34, 
     0.69, 0.69, 0.69, 1.38, 1.38, 1.38, 2.75, 2.75, 2.75, 5.5, 5.5, 
     5.5, 11, 11, 11, 22, 22, 22, 0.085, 0.34, 0.34, 0.34, 0.69, 0.69, 
     0.69, 1.38, 1.38, 1.38, 2.75, 2.75, 2.75, 5.5, 5.5, 5.5, 11, 
     11, 11, 22, 22, 22, 0.085, 0.34, 0.34, 0.34, 0.69, 0.69, 0.69, 
     1.38, 1.38, 1.38, 2.75, 2.75, 2.75, 5.5, 5.5, 5.5, 11, 11, 11, 
     22, 22, 22, 0.085, 0.34, 0.34, 0.34, 0.69, 0.69, 0.69, 1.38, 
     1.38, 1.38, 2.75, 2.75, 2.75, 5.5, 5.5, 5.5, 11, 11, 11, 22, 
     22, 22, 0.085, 0.34, 0.34, 0.34, 0.69, 0.69, 0.69, 1.38, 1.38, 
     1.38, 2.75, 2.75, 2.75, 5.5, 5.5, 5.5, 11, 11, 11, 22, 22, 22, 
     0.085, 0.34, 0.34, 0.34, 0.69, 0.69, 0.69, 1.38, 1.38, 1.38, 
     2.75, 2.75, 2.75, 5.5, 5.5, 5.5, 11, 11, 11, 22, 22, 22, 0.085, 
     0.34, 0.34, 0.34, 0.69, 0.69, 0.69, 1.38, 1.38, 1.38, 2.75, 2.75, 
     2.75, 5.5, 5.5, 5.5, 11, 11, 11, 22, 22, 22, 0.085, 0.34, 0.34, 
     0.34, 0.69, 0.69, 0.69, 1.38, 1.38, 1.38, 2.75, 2.75, 2.75, 5.5, 
     5.5, 5.5, 11, 11, 11, 22, 22, 22),
   cAMP = c(1.77, 3.35, 4, 6.1, 
     8.4, 12, 8.15, 13.25, 24.25, 17.85, 40.15, 49.35, 40.05, 61.85, 
     85.15, 58.8, 95.05, 118.5, 76.25, 116.7, 140.45, 90.4, 1.8, 4.2, 
     5.85, 4.7, 7.1, 9.2, 9, 15, 23.45, 25.4, 30.15, 46.9, 74.45, 
     51.85, 72.95, 83.7, 66.3, 101.25, 92.8, 87.5, 115.3, 109.4, 1.87, 
     3.6, 4.7, 4.2, 8.65, 8.6, 4.85, 13, 16.95, 13.85, 24.6, 34.6, 
     31.7, 57.45, 58.25, 49.05, 60.55, 77.8, 78.95, 74.15, 103.9, 
     89.85, 1.62, 3.65, 3.6, 4.95, 5.35, 7.35, 9, 10.8, 18.25, 19.6, 
     21.75, 26.05, 32.6, 57.05, 92.05, 99.9, 85.1, 92.3, 104.9, 87.55, 
     97.35, 101.6, 1.03, 1.69, 2.3, 2.95, 3.15, 5.05, 6.7, 7.6, 11.55, 
     12.8, 14.9, 23.75, 27.55, 34.85, 61.5, 50, 47.4, 57.2, 61.25, 
     38.7, 55.3, 63.2, 1.37, 3.95, 4, 3.75, 6, 10.6, 10, 16.2, 23.95, 
     22.3, 34.8, 61.75, 54.05, 62.25, 112.9, 105.6, 99.3, 137.15, 
     155.1, 101.95, 166.3, 177.6, 1.17, 3.15, 3.7, 3.7, 2.45, 6.45, 
     6.25, 11.85, 16.75, 23.55, 28.45, 42.45, 49.4, 51.75, 91.25, 
     77.1, 81.1, 122.9, 125.9, 72.9, 118.2, 117.95, 1.87, 5.4, 4.55, 
     3.05, 7.35, 7.1, 7.3, 11.1, 16.35, 14.15, 25.7, 27.85, 35.9, 
     49.3, 63.6, 72.95, 57.5, 71.45, 69.75, 69.95, 92.05, 88.55, 2.32, 
     4.85, 4.5, 4.2, 8.4, 7.9, 7.05, 12.9, 18.2, 16.1, 31.25, 37.55, 
     35.75, 65.95, 94.6, 71.65, 63.75, 68.85, 82.6, 83.7, 103.85, 
     93)),
row.names = 1:198,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = cAMP ~ conc | Run,
labels = list(x = "Concentration of relaxin",
  y = "Amount of cAMP released"),
units = list(x = "(ng/ml)", y = "(pmole/ml)"))
