% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbernppACmovement_exp.R
\name{dbernppACmovement_exp}
\alias{dbernppACmovement_exp}
\alias{rbernppACmovement_exp}
\title{Bernoulli point process for activity center movement (exponential kernel)}
\usage{
dbernppACmovement_exp(
  x,
  lowerCoords,
  upperCoords,
  s,
  lambda,
  baseIntensities,
  habitatGrid,
  numGridRows,
  numGridCols,
  numWindows,
  log = 0
)

rbernppACmovement_exp(
  n,
  lowerCoords,
  upperCoords,
  s,
  lambda,
  baseIntensities,
  habitatGrid,
  numGridRows,
  numGridCols,
  numWindows
)
}
\arguments{
\item{x}{Vector of x- and y-coordinates of a single spatial point (typically AC location at time t+1).}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all habitat windows. One row for each window. 
Each window should be of size 1x1 (after rescaling if necessary).}

\item{s}{Vector of x- and y-coordinates of the isotropic multivariate exponential distribution mean (AC location at time t).}

\item{lambda}{Rate parameter of the isotropic multivariate exponential distribution.}

\item{baseIntensities}{Vector of baseline habitat intensities for all habitat windows.}

\item{habitatGrid}{Matrix of habitat window indices. Baseline habitat intensities should match the order in \code{lowerCoords} and \code{upperCoords}. 
When the grid has only one row/column, artificial indices have to be provided to inflate \code{habitatGrid} in order to be able to use the distribution in \code{nimble} model code.}

\item{numGridRows, numGridCols}{Numbers of rows and columns of the habitat grid.}

\item{numWindows}{Number of habitat windows. This value (positive integer) can be used to truncate \code{lowerCoords} and \code{upperCoords} so that extra rows beyond \code{numWindows} are ignored.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
\code{dbernppACmovement_exp} gives the (log) probability density of the observation vector \code{x}. 
\code{rbernppACmovement_exp} gives coordinates of a randomly generated spatial point.
}
\description{
Density and random generation functions of the Bernoulli point process for activity center movement.
}
\details{
The \code{dbernppACmovement_exp} distribution is a NIMBLE custom distribution which can be used to model and simulate
movement of activity centers between consecutive occasions in open population models.
The distribution assumes that the new individual activity center location (\emph{x})
follows an isotropic exponential normal centered on the previous activity center (\emph{s}) with rate (\emph{lambda}).
}
\examples{
# Use the distribution in R
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)  
s <- c(1, 1) # Currrent activity center location
lambda <- 0.1
baseIntensities <- c(1:4)
habitatGrid <- matrix(c(1:4), nrow = 2, byrow = TRUE)
numRows <- nrow(habitatGrid)
numCols <- ncol(habitatGrid)
numWindows <- 4
# The log probability density of moving from (1,1) to (1.2, 0.8) 
dbernppACmovement_exp(c(1.2, 0.8), lowerCoords, upperCoords, s, lambda, baseIntensities, 
                      habitatGrid, numRows, numCols, numWindows, log = TRUE)
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang and Cyril Milleret
}
