% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MCMC_run.R
\name{runMCMC}
\alias{runMCMC}
\title{Run one or more chains of an MCMC algorithm and extract samples}
\usage{
runMCMC(mcmc, niter = 10000, nburnin = 0, nchains = 1, inits,
  setSeed = FALSE, progressBar = TRUE, silent = FALSE,
  returnCodaMCMC = FALSE)
}
\arguments{
\item{mcmc}{A NIMBLE MCMC algorithm.  See details.}

\item{niter}{Number of iterations to run each MCMC chain (default = 10000).}

\item{nburnin}{Number of initial samples to discard from each MCMC chain (default = 0).}

\item{nchains}{Number of MCMC chains to run (default = 1).}

\item{inits}{Optional argument to specify initial values for each chain.  See details.}

\item{setSeed}{Logical argument.  If \code{TRUE}, then R's random number seed is set to \code{i} (using \code{set.seed(i)}) at the onset of each MCMC chain number \code{i} (default = \code{FALSE}).}

\item{progressBar}{Logical argument.  If \code{TRUE}, an MCMC progress bar is displayed during execution of each MCMC chain (default = \code{TRUE}).}

\item{silent}{Logical argument.  If \code{TRUE}, then all output is suppressed during execution.  This overrides the \code{progressBar} argument (default = \code{FALSE}).}

\item{returnCodaMCMC}{Logical argument.  If \code{TRUE}, then a \code{coda} \code{mcmc} object is returned instead of an R matrix of samples, or when \code{nchains > 1} a \code{coda} \code{mcmc.list} object is returned containing \code{nchains} \code{mcmc} objects (default = \code{FALSE}).}
}
\value{
When \code{nchains = 1}, a matrix of MCMC samples.  When \code{nchains > 1}, a list of length \code{nchains}, where each list element is a matrix of MCMC samples.  If \code{returnCodaMCMC = TRUE}, then a \code{coda} \code{mcmc} or \code{mcmc.list} object is returned instead.
}
\description{
Takes as input an MCMC algorithm (ideally a compiled one for speed)
and runs the MCMC with one or more chains, automatically extracting
the samples.
}
\details{
The \code{mcmc} argument can be a compiled or uncompiled NIMBLE MCMC algorithm, which is generated using \code{buildMCMC}.  Using a compiled algorithm will give substantially faster execution.

If provided, the \code{inits} argument can be one of three things:
(1) a function to generate initial values, which will be executed to generate initial values at the beginning of each MCMC chain,
(2) a single named list of initial values which, will be used for each chain, or
(3) a list of length \code{nchains}, each element being a named list of initial values which be used for one MCMC chain.
The \code{inits} argument may also be omitted, in which case the current values in the \code{model} object will be used as the initial values of the first chain, and subsequent chains will begin using starting values where the previous chain ended.

Other aspects of the MCMC algorithm, such as sampler assignments and thinning, must be specified in advance using the MCMC configuration object (created using \code{configureMCMC}), which is then used to build the MCMC algorithm (using \code{buildMCMC}) argument.

The \code{niter} argument specifies the number of pre-thinning MCMC iterations, and the \code{nburnin} argument will remove post-thinning samples.

The MCMC option \code{mcmc$run(..., reset = FALSE)}, used to continue execution of an MCMC chain, is not available through \code{runMCMC()}.
}
\examples{
\dontrun{
code <- nimbleCode({
    mu ~ dnorm(0, sd = 1000)
    sigma ~ dunif(0, 1000)
    for(i in 1:10) {
        x[i] ~ dnorm(mu, sd = sigma)
    }
})
Rmodel <- nimbleModel(code)
Rmodel$setData(list(x = c(2, 5, 3, 4, 1, 0, 1, 3, 5, 3)))
Rmcmc <- buildMCMC(Rmodel)
Cmodel <- compileNimble(Rmodel)
Cmcmc <- compileNimble(Rmcmc, project = Rmodel)
inits <- function() list(mu = rnorm(1,0,1), sigma = runif(1,0,10))
samplesList <- runMCMC(Cmcmc, niter = 10000, nchains = 3, inits = inits)
}
}
\author{
Daniel Turek
}
\seealso{
\code{\link{configureMCMC}} \code{\link{buildMCMC}}
}

