% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{Dirichlet}
\alias{Dirichlet}
\alias{ddirch}
\alias{dirichlet}
\alias{rdirch}
\title{The Dirichlet Distribution}
\usage{
ddirch(x, alpha, log = FALSE)

rdirch(n = 1, alpha)
}
\arguments{
\item{x}{vector of values.}

\item{alpha}{vector of parameters of same length as \code{x}}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only \code{n=1} is handled currently).}
}
\value{
\code{ddirch} gives the density and \code{rdirch} generates random deviates.
}
\description{
Density and random generation for the Dirichlet distribution
}
\details{
See Gelman et al., Appendix A or the BUGS manual for mathematical details.
}
\examples{
alpha <- c(1, 10, 30)
x <- rdirch(1, alpha)
ddirch(x, alpha)
}
\author{
Christopher Paciorek
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

